% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/presynth.R
\name{presynth}
\alias{presynth}
\title{Create a presynth object}
\usage{
presynth(roadmap, synth_spec)
}
\arguments{
\item{roadmap}{A \code{roadmap} object from \code{roadmap()}.}

\item{synth_spec}{A \code{synth_spec} object from \code{synth_spec()}.}
}
\value{
A \code{presynth} object.
}
\description{
Create a presynth object
}
\examples{

# create roadmap
rm <- roadmap(
  conf_data = acs_conf_nw,
  start_data = acs_start_nw
) 

rpart_mod_reg <- parsnip::decision_tree() |>
  parsnip::set_engine(engine = "rpart") |>
  parsnip::set_mode(mode = "regression")

rpart_mod_class <- parsnip::decision_tree() |>
  parsnip::set_engine(engine = "rpart") |>
  parsnip::set_mode(mode = "classification")

synth_spec1 <- synth_spec(
  default_regression_model = rpart_mod_reg,
  default_regression_sampler = sample_rpart,
  default_classification_model = rpart_mod_class,
  default_classification_sampler = sample_rpart
)

# create a presynth object
# use defaults for noise, constraints, and replicates
presynth(
  roadmap = rm,
  synth_spec = synth_spec1
)

}
