% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dummy_dt.R
\name{dummy_dt}
\alias{dummy_dt}
\title{Fast creation of dummy variables}
\usage{
dummy_dt(.data, ..., longname = TRUE)
}
\arguments{
\item{.data}{data.frame}

\item{...}{Columns you want to create dummy variables from.
Very flexible, find in the examples.}

\item{longname}{logical. Should the output column labeled with the
original column name? Default uses \code{TRUE}.}
}
\value{
data.table
}
\description{
Quickly create dummy (binary) columns from character and factor type columns in the inputted data (and numeric columns if specified.)
This function is useful for statistical analysis when you want binary columns rather than character columns.
}
\details{
If no columns provided, will return the original data frame.
 When NA exist in the input column, they would also be considered. If
 the input character column contains both NA and string "NA", they would be
 merged.

This function is inspired by \pkg{fastDummies} package, but provides
simple and precise usage, whereas \code{fastDummies::dummy_cols} provides more
features for statistical usage.
}
\examples{
iris \%>\% dummy_dt(Species)
iris \%>\% dummy_dt(Species,longname = FALSE)

mtcars \%>\% head() \%>\% dummy_dt(vs,am)
mtcars \%>\% head() \%>\% dummy_dt("cyl|gear")

# when there are NAs in the column
df <- data.table(x = c("a", "b", NA, NA),y = 1:4)
df \%>\%
  dummy_dt(x)

# when NA  and "NA" both exist, they would be merged
df <- data.table(x = c("a", "b", NA, "NA"),y = 1:4)
df \%>\%
  dummy_dt(x)

}
\references{
https://stackoverflow.com/questions/18881073/creating-dummy-variables-in-r-data-table
}
\seealso{
\code{\link[fastDummies]{dummy_cols}}
}
