% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidydp.R
\name{dp_sum}
\alias{dp_sum}
\title{Differentially Private Sum}
\usage{
dp_sum(
  data,
  column,
  epsilon,
  delta = NULL,
  lower = NULL,
  upper = NULL,
  group_by = NULL,
  .budget = NULL
)
}
\arguments{
\item{data}{A data frame}

\item{column}{Column name to compute sum of}

\item{epsilon}{Privacy parameter}

\item{delta}{Privacy parameter (default: NULL, uses Laplace mechanism)}

\item{lower}{Lower bound of the data range}

\item{upper}{Upper bound of the data range}

\item{group_by}{Character vector of column names to group by (optional)}

\item{.budget}{Optional privacy budget object to track expenditure}
}
\value{
Data frame with (possibly grouped) private sums
}
\description{
Computes a differentially private sum of a numeric column.
}
\examples{
data <- data.frame(city = c("NYC", "LA", "NYC", "LA"),
                   sales = c(100, 200, 150, 250))
data \%>\% dp_sum("sales", epsilon = 0.1, lower = 0, upper = 1000, group_by = "city")
}
