% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_pkparam_sort.R
\name{h_pkparam_sort}
\alias{h_pkparam_sort}
\title{Sort pharmacokinetic data by \code{PARAM} variable}
\usage{
h_pkparam_sort(pk_data, key_var = "PARAMCD")
}
\arguments{
\item{pk_data}{(\code{data.frame})\cr pharmacokinetic data frame.}

\item{key_var}{(\code{string})\cr key variable used to merge pk_data and metadata created by \code{\link[=d_pkparam]{d_pkparam()}}.}
}
\value{
A pharmacokinetic \code{data.frame} sorted by a \code{PARAM} variable.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
library(dplyr)

adpp <- tern_ex_adpp \%>\% mutate(PKPARAM = factor(paste0(PARAM, " (", AVALU, ")")))
pk_ordered_data <- h_pkparam_sort(adpp)

}
