% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_diff.R
\name{h_miettinen_nurminen_var_est}
\alias{h_miettinen_nurminen_var_est}
\title{Variance Estimates in Strata following Miettinen and Nurminen}
\usage{
h_miettinen_nurminen_var_est(n1, n2, x1, x2, diff_par)
}
\arguments{
\item{n1}{(\code{numeric})\cr sample sizes in group 1.}

\item{n2}{(\code{numeric})\cr sample sizes in group 2.}

\item{x1}{(\code{numeric})\cr number of responders in group 1.}

\item{x2}{(\code{numeric})\cr number of responders in group 2.}

\item{diff_par}{(\code{numeric})\cr assumed difference in true proportions
(group 2 minus group 1).}
}
\value{
A named \code{list} with elements:
\itemize{
\item \code{p1_hat}: estimated proportion in group 1
\item \code{p2_hat}: estimated proportion in group 2
\item \code{var_est}: variance estimate of the difference in proportions
}
}
\description{
The variable names in this function follow the notation in the original
paper by \insertCite{MiettinenNurminen1985;textual}{tern}, cf. Appendix 1.
}
\references{
\insertAllCited{}
}
\keyword{internal}
