% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_diff.R
\name{check_diff_prop_ci}
\alias{check_diff_prop_ci}
\title{Check proportion difference arguments}
\usage{
check_diff_prop_ci(rsp, grp, strata = NULL, conf_level, correct = NULL)
}
\arguments{
\item{rsp}{(\code{logical})\cr vector indicating whether each subject is a responder or not.}

\item{grp}{(\code{factor})\cr vector assigning observations to one out of two groups
(e.g. reference and treatment group).}

\item{strata}{(\code{factor})\cr variable with one level per stratum and same length as \code{rsp}.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}

\item{correct}{(\code{flag})\cr whether to include the continuity correction. For further
information, see \code{\link[stats:prop.test]{stats::prop.test()}}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Verifies that and/or convert arguments into valid values to be used in the
estimation of difference in responder proportions.
}
\examples{
# example code
## "Mid" case: 4/4 respond in group A, 1/2 respond in group B.
nex <- 100 # Number of example rows
dta <- data.frame(
  "rsp" = sample(c(TRUE, FALSE), nex, TRUE),
  "grp" = sample(c("A", "B"), nex, TRUE),
  "f1" = sample(c("a1", "a2"), nex, TRUE),
  "f2" = sample(c("x", "y", "z"), nex, TRUE),
  stringsAsFactors = TRUE
)
check_diff_prop_ci(rsp = dta[["rsp"]], grp = dta[["grp"]], conf_level = 0.95)
}
