% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nl_ref_prices.R
\name{nl_ref_prices}
\alias{nl_ref_prices}
\title{A function to download the  Reference prices of the Dutch Costing Manual for one or multiple years}
\usage{
nl_ref_prices(
  year = "all",
  domain = "all",
  category = "all",
  unit = "all",
  short_unit = "all",
  currency = c("EUR", "INT$")
)
}
\arguments{
\item{year}{The year of which the reference price should be downloaded, multiple years are possible, default is the whole dataset}

\item{domain}{The domain of prices that should be included (one or more categories), default is including all categories}

\item{category}{The category of prices that should be included (one or more categories), default is including all categories}

\item{unit}{The reference price that should be included (one or multiple reference prices),  default is including the whole dataframe}

\item{short_unit}{The short variable name that should be included (one or more short variables), default is including all}

\item{currency}{The currency of the output of the prices. A decision can be made between EUR and INT$, the default is EUR.}
}
\value{
A dataframe or value with the Medical Reference price(s) of the Dutch Costing Manual for the specified years
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This function downloads the  Reference prices of the Dutch Costing Manual for one or multiple years. The prices are available in Euro (EUR) or International Dollar (INT$).
}
\examples{
# Example usage of the nl_med_prices function
# Calculate for year 2024 with the category Nursing
nl_ref_prices(year = "2024", category = "Nursing")

# Calculate for year 2022 and 2023 the category Nursing
nl_ref_prices(year = c(2022,2023), category = "Nursing")

# Calculate for year 2022 with the category Nursing in INT$
nl_ref_prices(year = "2022", category = "Nursing" , currency = "INT$")

}
\keyword{Costing}
\keyword{Dutch}
\keyword{Generic}
\keyword{Manual}
\keyword{Medical}
\keyword{Prices}
\keyword{Prices}
\keyword{Reference}
