% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_model_output_sick_sicker.R
\docType{data}
\name{data_model_output_sick_sicker}
\alias{data_model_output_sick_sicker}
\title{Example model output for the sick-sicker model}
\format{
An object of class \code{list} of length 9.
}
\usage{
data_model_output_sick_sicker
}
\description{
This data structure with several lists and vectors collecting a subset of the model outputs from the Sick-Sicker model intended for demonstrating the discounting in this package. The full model is described in the DARTH “Sick-Sicker” example.
Source code can be found here: https://github.com/DARTH-git/cohort-modeling-tutorial-intro
}
\details{
For the full reference read: Alarid-Escudero F, Krijkamp EM, Enns EA, Yang A, Hunink MGM, Pechlivanoglou P, Jalal H. An Introductory Tutorial on Cohort State-Transition Models in R Using a Cost-Effectiveness Analysis Example. Medical Decision Making, 2023;43(1):3-20. https://doi.org/10.1177/0272989X221103163

These data can be used for demonstrating how to apply some of the package functions like discounting for the results of a model-based cost-effectiveness model.

#' @format A list with the following components
\describe{
\item{l_m_M_annual}{Annual transition matrix for sick-sicker model.}
\item{l_m_M_monthly}{Monthly transition matrix for sick-sicker model.}
\item{v_wcc_annual}{Half-cycle correction weights for annual model.}
\item{v_wcc_monthly}{Half-cycle correction weights for monthly model.}
\item{v_names_str}{Names of the intervention strategies used in the model.}
\item{l_u_annual}{Annual utilities for each health state.}
\item{l_u_monthly}{Monthly utilities for each health state.}
\item{l_c_annual}{Annual costs for each health state.}
\item{l_c_monthly}{Monthly costs for each health state.}
}
}
\examples{
# Load the dataset
data("data_model_output_sick_sicker.rda")

# Load list in global environment
list2env(data_model_output_sick_sicker, envir = .GlobalEnv)
# Explore the available objects
ls(pattern = "l_|v_")

# View names of health states
v_names_str

# Inspect the first few cycles of the annual Markov trace for the first strategy
head(l_m_M_annual[[1]])

# Compare dimensions of annual and monthly traces
dim(l_m_M_annual[[1]])
dim(l_m_M_monthly[[1]])

# Apply the half cycle correction
## Loop through each strategy and calculate total utilities and costs ----

v_tot_qaly <- v_tot_cost <- c()
for (i in 1:length(v_names_str)) {
 v_u_str <- l_u_monthly[[i]]   # select the vector of state utilities for the i-th strategy
 v_c_str <- l_c_monthly[[i]]   # select the vector of state costs for the i-th strategy

  ###* Expected QALYs and costs per cycle
  ##* Vector of QALYs and Costs
  #* Apply state rewards
  v_qaly_str <- l_m_M_monthly[[i]] \%*\% v_u_str # sum the utilities of all states for each cycle
  v_cost_str <- l_m_M_monthly[[i]] \%*\% v_c_str # sum the costs of all states for each cycle

  ###*  Total expected QALYs and costs per strategy and apply half-cycle correction (if applicable)
  #* QALYs
  v_tot_qaly[i] <- t(v_qaly_str) \%*\% v_wcc_monthly
  #* Costs
  v_tot_cost[i] <- t(v_cost_str) \%*\% v_wcc_monthly
}
}
\keyword{datasets}
