# nolint start: indentation_linter.

# styler: off

# load hard dependencies used in tests
library(dplyr, warn.conflicts = FALSE)
options(lifecycle_verbosity = "warning")

# Same as a smaller subset of `ggplot2::msleep` dataset
# datapasta::dpasta(dplyr::select(ggplot2::msleep, brainwt, vore, conservation, sleep_total, sleep_rem))

msleep <- dplyr::tribble(
  ~brainwt,     ~vore,  ~conservation, ~sleep_total, ~sleep_rem,
        NA,   "carni",           "lc",         12.1,         NA,
    0.0155,    "omni",             NA,           17,        1.8,
        NA,   "herbi",           "nt",         14.4,        2.4,
   0.00029,    "omni",           "lc",         14.9,        2.3,
     0.423,   "herbi", "domesticated",            4,        0.7,
        NA,   "herbi",             NA,         14.4,        2.2,
        NA,   "carni",           "vu",          8.7,        1.4,
        NA,        NA,             NA,            7,         NA,
      0.07,   "carni", "domesticated",         10.1,        2.9,
    0.0982,   "herbi",           "lc",            3,         NA,
     0.115,   "herbi",           "lc",          5.3,        0.6,
    0.0055,   "herbi", "domesticated",          9.4,        0.8,
        NA,    "omni",           "lc",           10,        0.7,
    0.0064,   "herbi", "domesticated",         12.5,        1.5,
     0.001,    "omni",           "lc",         10.3,        2.2,
    0.0066,    "omni",             NA,          8.3,          2,
   0.00014,    "omni",           "lc",          9.1,        1.4,
    0.0108,   "carni",           "lc",         17.4,        3.1,
    0.0123,   "herbi",           "lc",          5.3,        0.5,
    0.0063,    "omni",           "lc",           18,        4.9,
     4.603,   "herbi",           "en",          3.9,         NA,
     3e-04, "insecti",           "lc",         19.7,        3.9,
     0.655,   "herbi", "domesticated",          2.9,        0.6,
     0.419,   "herbi", "domesticated",          3.1,        0.4,
    0.0035,    "omni",           "lc",         10.1,        3.5,
     0.115,    "omni",           "lc",         10.9,        1.1,
        NA,   "herbi",             NA,         14.9,         NA,
    0.0256,   "carni", "domesticated",         12.5,        3.2,
     0.005,    "omni",             NA,          9.8,        1.1,
        NA,   "herbi",           "cd",          1.9,        0.4,
        NA,   "carni",           "cd",          2.7,        0.1,
     0.325,   "carni",           "lc",          6.2,        1.5,
   0.01227,   "herbi",           "lc",          6.3,        0.6,
      1.32,    "omni",             NA,            8,        1.9,
        NA,   "herbi",           "vu",          9.5,        0.9,
     5.712,   "herbi",           "vu",          3.3,         NA,
        NA,   "carni",           "lc",         19.4,        6.6,
     0.179,    "omni",             NA,         10.1,        1.2,
        NA,   "herbi",           "lc",         14.2,        1.9,
     0.001,   "herbi",           "en",         14.3,        3.1,
        NA,   "herbi",             NA,         12.8,         NA,
     4e-04,   "herbi",           "nt",         12.5,        1.4,
   0.00025, "insecti",             NA,         19.9,          2,
        NA,   "herbi",           "nt",         14.6,         NA,
    0.0125,   "carni",             NA,           11,         NA,
        NA,   "herbi",           "lc",          7.7,        0.9,
        NA,   "carni",           "lc",         14.5,         NA,
    0.0121,   "herbi", "domesticated",          8.4,        0.9,
     0.175,   "herbi", "domesticated",          3.8,        0.6,
      0.44,    "omni",             NA,          9.7,        1.4,
        NA,   "carni",           "en",         15.8,         NA,
     0.157,   "carni",           "nt",         10.4,         NA,
        NA,   "carni",           "vu",         13.5,         NA,
      0.18,    "omni",             NA,          9.4,          1,
    0.0024,        NA,           "lc",         10.3,        2.7,
        NA,    "omni",           "lc",           11,         NA,
        NA,        NA,             NA,         11.5,         NA,
    0.0114,        NA,             NA,         13.7,        1.8,
        NA,   "carni",           "vu",          3.5,        0.4,
        NA,   "carni",           "vu",          5.6,         NA,
        NA,   "herbi",             NA,         11.1,        1.5,
     0.081, "insecti",           "en",         18.1,        6.1,
     0.021,        NA,           "lc",          5.4,        0.5,
    0.0019,   "herbi",           "lc",           13,        2.4,
        NA,    "omni",             NA,          8.7,         NA,
      0.02,    "omni",             NA,          9.6,        1.4,
    0.0012, "insecti",           "lc",          8.4,        2.1,
   0.00118,   "herbi",             NA,         11.3,        1.1,
     0.003,        NA,             NA,         10.6,        2.4,
    0.0057,   "herbi",           "lc",         16.6,         NA,
     0.004,   "herbi",           "lc",         13.8,        3.4,
        NA,   "herbi",           "lc",         15.9,          3,
   0.00033,        NA,             NA,         12.8,          2,
      0.18,    "omni", "domesticated",          9.1,        2.4,
     0.025, "insecti",             NA,          8.6,         NA,
        NA,   "herbi",             NA,         15.8,         NA,
     0.169,   "herbi",           "vu",          4.4,          1,
    0.0026,    "omni",             NA,         15.6,        2.3,
    0.0025,    "omni",             NA,          8.9,        2.6,
        NA,   "carni",             NA,          5.2,         NA,
    0.0175,   "carni",             NA,          6.3,        1.3,
    0.0445,   "carni",             NA,         12.5,         NA,
    0.0504,   "carni",             NA,          9.8,        2.4
)

data_with_subid <- dplyr::tribble(
  ~score, ~condition, ~id,
      70,        "5", "1",
    82.5,        "1", "1",
    97.5,        "2", "1",
     100,        "3", "1",
    52.5,        "4", "1",
    62.5,        "4", "2",
    92.5,        "5", "2",
      70,        "1", "2",
      90,        "2", "2",
    92.5,        "3", "2",
      90,        "2", "3",
      75,        "3", "3",
      60,        "3", "4",
      90,        "4", "3",
      85,        "2", "4",
    67.5,        "1", "3",
      90,        "5", "4",
    72.5,        "5", "3",
      45,        "4", "4",
      60,        "1", "4",
    72.5,        "1", "5",
      80,        "4", "5",
     100,        "3", "5",
     100,        "5", "5",
    97.5,        "2", "5",
      95,        "5", "6",
      65,        "1", "6",
    87.5,        "2", "6",
      90,        "3", "6",
    62.5,        "4", "6",
     100,        "4", "7",
     100,        "5", "7",
    97.5,        "1", "7",
     100,        "2", "7",
    97.5,        "3", "7",
      95,        "2", "8",
    82.5,        "3", "8",
    82.5,        "4", "8",
      40,        "1", "8",
    92.5,        "5", "8",
      85,        "3", "9",
    72.5,        "2", "9",
      35,        "5", "9",
    27.5,        "4", "9",
    82.5,        "1", "9"
)

data_meta <- dplyr::tribble(
  ~study,          ~estimate, ~std.error,
  "Morton",        -0.83035,  1.24702,
  "Rasmussen",     -1.05605,  0.41407,
  "Smith",         -1.27834,  0.80814,
  "Abraham",       -0.04349,  1.42951,
  "Feldstedt",     0.22314,   0.48917,
  "Schechter",     -2.40752,  1.07221,
  "Ceremuzynski",  -1.28093,  1.19373,
  "Bertschat",     -1.1917,   1.66129,
  "Singh",         -0.69575,  0.53618,
  "Pereira",       -2.20827,  1.10965,
  "Schechter 1",   -2.03816,  0.78073,
  "Golf",          -0.85015,  0.61845,
  "Thogersen",     -0.79323,  0.62587,
  "LIMIT-2",       -0.29934,  0.14657,
  "Schechter 2",   -1.57079,  0.57404,
  "ISIS-4",        0.05759,   0.03164
)

# styler: on

# nolint end
