% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula.utilities.R
\name{trim_env}
\alias{trim_env}
\alias{trim_env.environment}
\alias{trim_env.default}
\title{Make a copy of an environment with just the selected objects.}
\usage{
trim_env(object, keep = NULL, ...)

\method{trim_env}{environment}(object, keep = NULL, ...)

\method{trim_env}{default}(object, keep = NULL, ...)
}
\arguments{
\item{object}{An \code{\link{environment}} or an object with
\code{\link[=environment]{environment()}} and \verb{environment()<-} methods.}

\item{keep}{A character vector giving names of variables in the
environment (including its ancestors) to copy over, defaulting to
dropping all. Variables that cannot be resolved are silently
ignored.}

\item{...}{Additional arguments, passed on to lower-level methods.}
}
\value{
An object of the same type as \code{object}, with updated
environment. If \code{keep} is empty, the environment is \code{\link[=baseenv]{baseenv()}};
if not empty, it's a new environment with \code{\link[=baseenv]{baseenv()}} as parent.
}
\description{
Make a copy of an environment with just the selected objects.
}
\section{Methods (by class)}{
\itemize{
\item \code{trim_env(environment)}: A method for environment objects.

\item \code{trim_env(default)}: Default method, for objects such as \code{\link{formula}} and \code{\link{function}} that have \code{\link[=environment]{environment()}} and \verb{environment()<-} methods.

}}
