% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_data.R
\name{addDataDensity}
\alias{addDataDensity}
\title{Add data from a density defined by a vector of integers}
\usage{
addDataDensity(dtOld, dataDist, varname, uselimits = FALSE, na.rm = TRUE)
}
\arguments{
\item{dtOld}{Name of data table that is to be updated.}

\item{dataDist}{Numeric vector. Defines the desired density.}

\item{varname}{Character. Name of the variable.}

\item{uselimits}{Logical. If TRUE, the minimum and maximum of the input data 
vector are used as limits for sampling. Defaults to FALSE, in which case a 
smoothed density that extends beyond these limits is used.}

\item{na.rm}{Logical. If TRUE (default), missing values in `dataDist` are 
removed. If FALSE, the data will retain the same proportion of missing values.}
}
\value{
A data table with the generated data.
}
\description{
Data are generated from an a density defined by a vector of integers.
}
\examples{
def <- defData(varname = "x1", formula = 5, dist = "poisson")

data_dist <- data_dist <- c(1, 2, 2, 3, 4, 4, 4, 5, 6, 6, 7, 7, 7, 8, 9, 10, 10)

dd <- genData(500, def)
dd <- addDataDensity(dd, data_dist, varname = "x2")
dd <- addDataDensity(dd, data_dist, varname = "x3", uselimits = TRUE)
}
\concept{generate_data}
