#' Example data set for construction of selection index
#' @name data
#' @docType data
#' @usage data(data)
#'
#' A data set containing the information on random (sire), fixed (farm, season and period)
#'  effects and three traits namely total milk yield, peak yield and age at first calving.
#'  A total of 689 observations of daughters born to 7 sires are given.
#'
#' @format A data frame with 689 rows and 7 columns:
#' \describe{
#'   \item{animal}{animal id of the cows}
#'   \item{sire}{factor sire of the cows}
#'   \item{farm}{factor farm from which the data were collected}
#'   \item{soc}{factor The season of calving of a cow}
#'   \item{poc}{factor The period of calving of a cow}
#'   \item{tmy}{numeric Total lactation milk yield in Kg}
#'   \item{py}{numeric The peak yield in Kg}
#'   \item{fatyield}{numeric The fat yield in Kg}
#' }
#'
#' @usage data(data)
#'
"data"