% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_ord_from_pool.R
\name{prob_ord_from_pool}
\alias{prob_ord_from_pool}
\title{verdict probabilities based on jury pool sentiment for ordered verdict options.}
\usage{
prob_ord_from_pool(jury_n, verdict_options, verdict_props, digits = NULL)
}
\arguments{
\item{jury_n}{Integer. Number of jurors.}

\item{verdict_options}{Character vector of ordered verdict labels
(e.g., `c("NG","M2","M1")`). Order matters: left = most lenient.}

\item{verdict_props}{Numeric vector specifying proportion of jurors who support
the respective verdict_options in the population from which jurors are drawn.
(e.g., `c(.25,.50,.25)`). Must correspond to verdict_options.}

\item{digits}{Integer. Optional, number of digits to round in the returned matrix.}
}
\value{
A vector of length K that are probabilities of the ordered verdicts.
}
\description{
verdict probabilities based on jury pool sentiment for ordered verdict options.
}
\examples{
library(sate)

# Three-verdict ordered model with a 12-person jury:
prob_ord_from_pool(12, c("NG", "M2", "M1"), c(.25,.50,.25), digits=3)

}
\seealso{
[transition.matrix.ordered]
}
