% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelcheck.R
\name{modelcheck}
\alias{modelcheck}
\alias{modelcheck.lm}
\title{Model checking plots
Compact layout for model checking plots.}
\usage{
modelcheck(x, ...)

\method{modelcheck}{lm}(x, which = 1:3, mar = c(3, 4, 1.5, 4), ...)
}
\arguments{
\item{x}{The fitted model.}

\item{which}{The plot(s) to be drawn. Residuals vs fitted values (
\code{which = v1}), 
histogram and QQ plot of residuals (\code{which = 2}), Cook's distance plot 
(\code{which = 2}).}

\item{mar}{Margins applied to each selected plot.}

\item{\ldots}{any other arguments to pass to \code{\link{plot}}}
}
\description{
Model checking plots
Compact layout for model checking plots.
}
\section{Methods (by class)}{
\itemize{
\item \code{modelcheck(lm)}: Model checking plots

}}
\examples{
x = 1:30
y = rnorm(30)
lm.fit = lm(y~x)
# Plot resids vs fitted only
modelcheck(lm.fit, 1)

# Plot resids vs fitted, and histogram and QQ plot
modelcheck(lm.fit, 1:2)

# Plot all
modelcheck(lm.fit)
}
