% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress_utils.R
\name{configure_progress}
\alias{configure_progress}
\title{Configure Progress Handlers}
\usage{
configure_progress(handler = "txtprogressbar", ...)
}
\arguments{
\item{handler}{Character string specifying the handler type:
\itemize{
\item \code{"progress"}: progress package style (if available)
\item \code{"txtprogressbar"}: base R text progress bar
\item \code{"cli"}: cli package style (if available)
\item \code{"none"}: Disable progress reporting
\item \code{NULL}: Use progressr default handlers
}}

\item{...}{Additional arguments passed to \code{progressr::handlers()}}
}
\value{
Invisibly returns the configured handlers (via \code{progressr::handlers()}).
}
\description{
Convenience function to configure progressr handlers for the current session.
}
\details{
This is a convenience wrapper around \code{progressr::handlers()}.
If progressr is not available, a warning is issued and the function returns NULL.
}
\examples{
\dontrun{
# Use base R text progress bar
configure_progress("txtprogressbar")

# Use cli style (if cli package is installed)
configure_progress("cli")

# Disable progress reporting
configure_progress("none")
}

}
\seealso{
\code{\link[progressr:handlers]{progressr::handlers()}}
}
