#' Encode the CIGAR string for a pairwise alignment
#'
#' @param aligned.ref An aligned reference sequence
#' @param aligned.reads An aligned read sequence
#' 
#' @return A CIGAR string
#' 
#' @examples
#' \dontrun{
#'     encodeCIGAR()
#' }
#'
#' @noRd
encodeCIGAR <- function(aligned.ref, aligned.reads){
	df <- data.frame(
		ref_seq = unlist( strsplit(aligned.ref,"") ),
		reads_seq = unlist( strsplit(aligned.reads,"") ),
		stringsAsFactors = FALSE
	)
	df$cigar <- "M"
	df$cigar[ df$ref_seq!="-" & df$reads_seq=="-" ] <- "D"
	df$cigar[ df$ref_seq=="-" & df$reads_seq!="-" ] <- "I"
	cigar.str <- paste(df$cigar, collapse="")
	match.M <- gregexpr("M+", cigar.str)
	match.D <- gregexpr("D+", cigar.str)
	match.I <- gregexpr("I+", cigar.str)
	op <- c()
	if(match.M[[1]][1]!=-1){
		df.M <- data.frame(
			code = "M",
			length = attr(match.M[[1]],"match.length"),
			pos = match.M[[1]],
			stringsAsFactors = FALSE
		)
		op <- rbind(op, df.M)
	}
	if(match.D[[1]][1]!=-1){
		df.D <- data.frame(
			code = "D",
			length = attr(match.D[[1]],"match.length"),
			pos = match.D[[1]],
			stringsAsFactors = FALSE
		)
		op <- rbind(op, df.D)
	}
	if(match.I[[1]][1]!=-1){
		df.I <- data.frame(
			code = "I",
			length = attr(match.I[[1]],"match.length"),
			pos = match.I[[1]],
			stringsAsFactors = FALSE
		)
		op <- rbind(op, df.I)
	}
	op <- op[ order(op$pos), ]
	cigar <- paste( paste(op$length, op$code, sep="") , collapse="" )
	return(cigar)
}
