% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srt_statistic.r
\name{srt_statistic}
\alias{srt_statistic}
\alias{srt_statistic.wilcoxon}
\alias{srt_statistic.shift}
\alias{srt_statistic.asymptotic}
\title{Calculate the test statistic for a signed-rank test.}
\usage{
srt_statistic(x, ...)

\method{srt_statistic}{wilcoxon}(x, ...)

\method{srt_statistic}{shift}(x, ...)

\method{srt_statistic}{asymptotic}(x, warn_zd = FALSE, ...)
}
\arguments{
\item{x}{(named list)\cr
The object returned by \code{\link[=srt_method]{srt_method()}} in a 'srt pipeline'.}

\item{...}{dots arguments are not used.}

\item{warn_zd}{(Scalar logical: \code{c(FALSE, TRUE)})\cr
Used for root-finding algorithm 'Z(d)' in confidence interval test inversion.
If \code{TRUE} return a warning and exit with value \code{statistic = 0}.}
}
\value{
list

It carries forward the class selected by \code{\link[=srt_method]{srt_method()}}.
}
\description{
Calculates the test statistic for a signed-rank test.
}
\keyword{internal}
