% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization-utils.R
\name{tukeyboxplot}
\alias{tukeyboxplot}
\title{A Tukey box-and-whisker plot}
\usage{
tukeyboxplot(
  y,
  x,
  data,
  by = NULL,
  jitter = FALSE,
  box_width = 1/3,
  jitter_width = 1/5,
  xlab = NULL,
  ylab = NULL
)
}
\arguments{
\item{y}{The outcome variable}

\item{x}{The optional independent/predictor/grouping variable}

\item{data}{The data frame with the \code{y} and (optionally) \code{x} values.}

\item{by}{An optional variable, usually categorical (factor or character), by
which the points in the box-and-whisker plots are grouped and coloured.}

\item{jitter}{A logical variable, defaulting to \code{FALSE}, that indicates if
all points in each box-and-whisker plot should be shown as jittered points.}

\item{box_width}{The width of box in each box-and-whisker plot. The default
used, \code{box_width = 1/3}, means that boxes will be relatively narrow.}

\item{jitter_width}{The width of the jitter relative to box width. For
example, set \code{jitter_width = 1} if you want the jitter to be as wide the
box.}

\item{xlab}{The label of the x-axis (defaults to the \code{x} variable name).}

\item{ylab}{The label of the y-axis (defaults to the \code{y} variable name).}
}
\value{
A \code{ggplot2::ggplot} object, which may be modified with further \code{ggplot2}
commands.
}
\description{
This function is a wrapper around a typical \code{ggplot} based box-and-whisker
plot, i.e. using \code{geom_boxplot}, which implements the Tukey variant of the
box-and-whisker plot. The \code{y} variable is the outcome variable whose
distribution is represented by the box-and-whisker plot. If the \code{x} variable
is missing, then a single box-and-whisker plot using all values of \code{y} is
shown. If an \code{x} variable is used, this is used an the independent variable
and one box-and-whisker plot is provided for each set of \code{y} values that
correspond to each unique value of \code{x}. For this reason, \code{x} is usually a
categorical variable. If \code{x} is a continuous numeric variable, it ideally
should have relatively few unique values, so that each value of \code{x}
corresponds to a sufficiently large set of \code{y} values.
}
\examples{
# A single box-and-whisker plot
tukeyboxplot(y = time, data = vizverb)
# One box-and-whisker plot for each value of a categorical variable
tukeyboxplot(y = time, x = task, data = vizverb)
# Box-and-whisker plots with jitters
tukeyboxplot(y = time, x = task, data = vizverb,  jitter = TRUE)
# `tukeyboxplot` can be used with a continuous numeric variable too
tukeyboxplot(y = len, x = dose, data = ToothGrowth)
tukeyboxplot(y = len, x = dose, data = ToothGrowth,
             by = supp, jitter = TRUE, box_width = 0.5, jitter_width = 1)
}
