% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-precision.R
\name{plot_precision_fan_chart}
\alias{plot_precision_fan_chart}
\title{Precision assurance as a function of sample size}
\usage{
plot_precision_fan_chart(
  power_results,
  ci_width_target,
  effect_filter = NULL,
  colour_by = NULL,
  title = NULL,
  subtitle = NULL
)
}
\arguments{
\item{power_results}{Output from a \verb{brms_inla_power*} function, or a
data.frame with at least columns \code{n} and \code{ci_width}, plus any
effect-grid columns (e.g. \code{treatment}, \code{age_effect}).}

\item{ci_width_target}{Numeric, target width for the credible interval.
Assurance is defined as Pr(ci_width <= ci_width_target).}

\item{effect_filter}{Optional named list for filtering effect-grid
columns, e.g. \code{list(treatment = 0.3)}.}

\item{colour_by}{Optional name of an effect-grid column to colour
separate curves by. If \code{NULL}, only n is used.}

\item{title, subtitle}{Optional plot labels.}
}
\value{
A ggplot object.
}
\description{
Plots the proportion of simulations in which the posterior credible
interval width is less than or equal to a target, as a function of
sample size n. Optionally colours separate curves by an effect-grid
variable.
}
\details{
This implementation works directly from the per-simulation results
(column \code{ci_width}) and does not rely on the robustness engine.
}
