% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plumber2.R
\name{Plumber2}
\alias{Plumber2}
\title{The Plumber2 Class}
\description{
This class encapsulates all of the logic of a plumber2 api, and is what gets
passed around in the functional api of plumber2. The \code{Plumber2} class is a
subclass of the \link[fiery:Fire]{fiery::Fire} class. Please consult the documentation for
this for additional information on what this type of server is capable of.
Note that the \code{Plumber2} objects are reference objects, meaning that any
change to it will change all instances of the object.
\subsection{Initialization}{

A new \code{Plumber2}-object is initialized using the \code{new()} method on the
generator:

\tabular{l}{
\code{api <- Plumber2$new()}
}

However, most users will use the functional api of the package and thus
construct one using \code{\link[=api]{api()}}
}

\subsection{Copying}{

As \code{Plumber2} objects are using reference semantics new copies of an api cannot
be made simply be assigning it to a new variable. If a true copy of a \code{Plumber2}
object is desired, use the \code{clone()} method.
}
}
\section{Super class}{
\code{\link[fiery:Fire]{fiery::Fire}} -> \code{Plumber2}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{request_router}}{The router handling requests}

\item{\code{header_router}}{The router handling partial requests (the request
will pass through this router prior to reading in the body)}

\item{\code{doc_type}}{The type of API documentation to generate. Can be either
\code{"rapidoc"} (the default), \code{"redoc"}, \code{"swagger"}, or \code{NULL} (equating to
not generating API docs)}

\item{\code{doc_path}}{The URL path to serve the api documentation from}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Plumber2-new}{\code{Plumber2$new()}}
\item \href{#method-Plumber2-format}{\code{Plumber2$format()}}
\item \href{#method-Plumber2-ignite}{\code{Plumber2$ignite()}}
\item \href{#method-Plumber2-add_route}{\code{Plumber2$add_route()}}
\item \href{#method-Plumber2-request_handler}{\code{Plumber2$request_handler()}}
\item \href{#method-Plumber2-message_handler}{\code{Plumber2$message_handler()}}
\item \href{#method-Plumber2-redirect}{\code{Plumber2$redirect()}}
\item \href{#method-Plumber2-parse_file}{\code{Plumber2$parse_file()}}
\item \href{#method-Plumber2-add_api_doc}{\code{Plumber2$add_api_doc()}}
\item \href{#method-Plumber2-add_shiny}{\code{Plumber2$add_shiny()}}
\item \href{#method-Plumber2-forward}{\code{Plumber2$forward()}}
\item \href{#method-Plumber2-clone}{\code{Plumber2$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="async"><a href='../../fiery/html/Fire.html#method-Fire-async'><code>fiery::Fire$async()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="attach"><a href='../../fiery/html/Fire.html#method-Fire-attach'><code>fiery::Fire$attach()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="close_ws_con"><a href='../../fiery/html/Fire.html#method-Fire-close_ws_con'><code>fiery::Fire$close_ws_con()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="delay"><a href='../../fiery/html/Fire.html#method-Fire-delay'><code>fiery::Fire$delay()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="exclude_static"><a href='../../fiery/html/Fire.html#method-Fire-exclude_static'><code>fiery::Fire$exclude_static()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="extinguish"><a href='../../fiery/html/Fire.html#method-Fire-extinguish'><code>fiery::Fire$extinguish()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="get_data"><a href='../../fiery/html/Fire.html#method-Fire-get_data'><code>fiery::Fire$get_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="has_plugin"><a href='../../fiery/html/Fire.html#method-Fire-has_plugin'><code>fiery::Fire$has_plugin()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="header"><a href='../../fiery/html/Fire.html#method-Fire-header'><code>fiery::Fire$header()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="is_running"><a href='../../fiery/html/Fire.html#method-Fire-is_running'><code>fiery::Fire$is_running()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="log"><a href='../../fiery/html/Fire.html#method-Fire-log'><code>fiery::Fire$log()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="off"><a href='../../fiery/html/Fire.html#method-Fire-off'><code>fiery::Fire$off()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="on"><a href='../../fiery/html/Fire.html#method-Fire-on'><code>fiery::Fire$on()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="reignite"><a href='../../fiery/html/Fire.html#method-Fire-reignite'><code>fiery::Fire$reignite()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="remove_async"><a href='../../fiery/html/Fire.html#method-Fire-remove_async'><code>fiery::Fire$remove_async()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="remove_data"><a href='../../fiery/html/Fire.html#method-Fire-remove_data'><code>fiery::Fire$remove_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="remove_delay"><a href='../../fiery/html/Fire.html#method-Fire-remove_delay'><code>fiery::Fire$remove_delay()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="remove_time"><a href='../../fiery/html/Fire.html#method-Fire-remove_time'><code>fiery::Fire$remove_time()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="resume"><a href='../../fiery/html/Fire.html#method-Fire-resume'><code>fiery::Fire$resume()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="safe_call"><a href='../../fiery/html/Fire.html#method-Fire-safe_call'><code>fiery::Fire$safe_call()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="send"><a href='../../fiery/html/Fire.html#method-Fire-send'><code>fiery::Fire$send()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="serve_static"><a href='../../fiery/html/Fire.html#method-Fire-serve_static'><code>fiery::Fire$serve_static()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="set_client_id_converter"><a href='../../fiery/html/Fire.html#method-Fire-set_client_id_converter'><code>fiery::Fire$set_client_id_converter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="set_data"><a href='../../fiery/html/Fire.html#method-Fire-set_data'><code>fiery::Fire$set_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="set_logger"><a href='../../fiery/html/Fire.html#method-Fire-set_logger'><code>fiery::Fire$set_logger()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="start"><a href='../../fiery/html/Fire.html#method-Fire-start'><code>fiery::Fire$start()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="stop"><a href='../../fiery/html/Fire.html#method-Fire-stop'><code>fiery::Fire$stop()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="test_header"><a href='../../fiery/html/Fire.html#method-Fire-test_header'><code>fiery::Fire$test_header()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="test_message"><a href='../../fiery/html/Fire.html#method-Fire-test_message'><code>fiery::Fire$test_message()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="test_request"><a href='../../fiery/html/Fire.html#method-Fire-test_request'><code>fiery::Fire$test_request()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="test_websocket"><a href='../../fiery/html/Fire.html#method-Fire-test_websocket'><code>fiery::Fire$test_websocket()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="time"><a href='../../fiery/html/Fire.html#method-Fire-time'><code>fiery::Fire$time()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fiery" data-topic="Fire" data-id="trigger"><a href='../../fiery/html/Fire.html#method-Fire-trigger'><code>fiery::Fire$trigger()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber2-new"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber2-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Plumber2} api
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber2$new(
  host = get_opts("host", "127.0.0.1"),
  port = get_opts("port", 8080),
  doc_type = get_opts("docType", "rapidoc"),
  doc_path = get_opts("docPath", "__docs__"),
  reject_missing_methods = get_opts("rejectMissingMethods", FALSE),
  ignore_trailing_slash = get_opts("ignoreTrailingSlash", TRUE),
  max_request_size = get_opts("maxRequestSize"),
  shared_secret = get_opts("sharedSecret"),
  compression_limit = get_opts("compressionLimit", 1000),
  default_async = get_opts("async", "mirai"),
  env = caller_env()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{host}}{A string overriding the default host}

\item{\code{port}}{An port number overriding the default port}

\item{\code{doc_type}}{The type of API documentation to generate. Can be either
\code{"rapidoc"} (the default), \code{"redoc"}, \code{"swagger"}, or \code{NULL} (equating to
not generating API docs)}

\item{\code{doc_path}}{The URL path to serve the api documentation from}

\item{\code{reject_missing_methods}}{Should requests to paths that doesn't
have a handler for the specific method automatically be rejected with a
405 Method Not Allowed response with the correct Allow header informing
the client of the implemented methods. Assigning a handler to \code{"any"} for
the same path at a later point will overwrite this functionality. Be
aware that setting this to \code{TRUE} will prevent the request from falling
through to other routes that might have a matching method and path. This
setting anly affects handlers on the request router.}

\item{\code{ignore_trailing_slash}}{Logical. Should the trailing slash of a path
be ignored when adding handlers and handling requests. Setting this will
not change the request or the path associated with but just ensure that
both \code{path/to/resource} and \verb{path/to/resource/} ends up in the same
handler. This setting will only affect routes that are created automatically.}

\item{\code{max_request_size}}{Sets a maximum size of request bodies. Setting this
will add a handler to the header router that automatically rejects requests
based on their \code{Content-Length} header}

\item{\code{shared_secret}}{Assigns a shared secret to the api. Setting this will
add a handler to the header router that automatically rejects requests if
their \code{Plumber-Shared-Secret} header doesn't contain the same value. Be aware
that this type of authentication is very weak. Never put the shared secret in
plain text but rely on e.g. the keyring package for storage. Even so, if
requests are send over HTTP (not HTTPS) then anyone can read the secret and
use it}

\item{\code{compression_limit}}{The size threshold in bytes for trying to
compress the response body (it is still dependant on content negotiation)}

\item{\code{default_async}}{The default evaluator to use for async request
handling}

\item{\code{env}}{An environment that will be used as the default execution
environment for the API}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Plumber2} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber2-format"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber2-format}{}}}
\subsection{Method \code{format()}}{
Human readable description of the api object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber2$format(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber2-ignite"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber2-ignite}{}}}
\subsection{Method \code{ignite()}}{
Begin running the server. Will trigger the \code{start} event
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber2$ignite(
  block = FALSE,
  showcase = is_interactive(),
  ...,
  silent = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{block}}{Should the console be blocked while running (alternative is
to run in the background)}

\item{\code{showcase}}{Should the default browser open up at the server address.
If \code{TRUE} then a browser opens at the root of the api, unless the api
contains OpenAPI documentation in which case it will open at that
location. If a string the string is used as a path to add to the root
before opening.}

\item{\code{...}}{Arguments passed on to the \code{start} handler}

\item{\code{silent}}{Should startup messaging by silenced}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber2-add_route"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber2-add_route}{}}}
\subsection{Method \code{add_route()}}{
Add a new route to either the request or header router
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber2$add_route(name, route = NULL, header = FALSE, after = NULL, root = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the route to add. If a route is already present
with this name then the provided route (if any) is merged into it}

\item{\code{route}}{The route to add. If \code{NULL} a new empty route will be
created}

\item{\code{header}}{Logical. Should the route be added to the header router?}

\item{\code{after}}{The location to place the new route on the stack. \code{NULL}
will place it at the end. Will not have an effect if a route with the
given name already exists.}

\item{\code{root}}{The root path to serve this route from.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber2-request_handler"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber2-request_handler}{}}}
\subsection{Method \code{request_handler()}}{
Add a handler to a request. See \link{api_request_handlers} for
detailed information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber2$request_handler(
  method,
  path,
  handler,
  serializers,
  parsers = NULL,
  use_strict_serializer = FALSE,
  download = FALSE,
  async = FALSE,
  then = NULL,
  doc = NULL,
  route = NULL,
  header = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{The HTTP method to attach the handler to}

\item{\code{path}}{A string giving the path the handler responds to.}

\item{\code{handler}}{A handler function to call when a request is matched to
the path}

\item{\code{serializers}}{A named list of serializers that can be used to format
the response before sending it back to the client. Which one is selected
is based on the request \code{Accept} header}

\item{\code{parsers}}{A named list of parsers that can be used to parse the
request body before passing it in as the \code{body} argument. Which one is
selected is based on the request \code{Content-Type} header}

\item{\code{use_strict_serializer}}{By default, if a serializer that respects
the requests \code{Accept} header cannot be found, then the first of the
provided ones are used. Setting this to \code{TRUE} will instead send back a
\verb{406 Not Acceptable} response}

\item{\code{download}}{Should the response mark itself for download instead of
being shown inline? Setting this to \code{TRUE} will set the
\code{Content-Disposition} header in the response to \code{attachment}. Setting it
to a string is equivalent to setting it to \code{TRUE} but will in addition
also set the default filename of the download to the string value}

\item{\code{async}}{If \code{FALSE} create a regular handler. If \code{TRUE}, use the
default async evaluator to create an async handler. If a string, the
async evaluator registered to that name is used. If a function is
provided then this is used as the async evaluator}

\item{\code{then}}{A function to call at the completion of an async handler}

\item{\code{doc}}{OpenAPI documentation for the handler. Will be added to the
\verb{paths$<handler_path>$<handler_method>} portion of the API.}

\item{\code{route}}{The route this handler should be added to. Defaults to the
last route in the stack. If the route does not exist it will be created
as the last route in the stack.}

\item{\code{header}}{Logical. Should the handler be added to the header router}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber2-message_handler"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber2-message_handler}{}}}
\subsection{Method \code{message_handler()}}{
Add a handler to a WebSocket message. See \link{api_message} for
detailed information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber2$message_handler(handler, async = FALSE, then = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{handler}}{A function conforming to the specifications laid out in
\code{\link[=api_message]{api_message()}}}

\item{\code{async}}{If \code{FALSE} create a regular handler. If \code{TRUE}, use the
default async evaluator to create an async handler. If a string, the
async evaluator registered to that name is used. If a function is
provided then this is used as the async evaluator}

\item{\code{then}}{A function to call at the completion of an async handler}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber2-redirect"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber2-redirect}{}}}
\subsection{Method \code{redirect()}}{
Add a redirect to the header router. Depending on the value
of \code{permanent} it will respond with a 307 Temporary Redirect or 308
Permanent Redirect. \code{from} and \code{to} can contain path parameters and
wildcards which will be matched between the two to construct the correct
redirect path.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber2$redirect(method, from, to, permanent = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{The HTTP method the redirect should respond to}

\item{\code{from}}{The path the redirect should respond to}

\item{\code{to}}{The path/URL to redirect the incoming request towards. After
resolving any path parameters and wildcards it will be used in the
\code{Location} header}

\item{\code{permanent}}{Logical. Is the redirect considered permanent or
temporary? Determines the type of redirct status code to use}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber2-parse_file"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber2-parse_file}{}}}
\subsection{Method \code{parse_file()}}{
Parses a plumber file and updates the app according to it
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber2$parse_file(file, env = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{The path to a file to parse}

\item{\code{env}}{The parent environment to the environment the file should be
evaluated in. If \code{NULL} the environment provided at construction will be
used}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber2-add_api_doc"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber2-add_api_doc}{}}}
\subsection{Method \code{add_api_doc()}}{
Add a (partial) OpenAPI spec to the api docs
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber2$add_api_doc(doc, overwrite = FALSE, subset = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{doc}}{A list with the OpenAPI documentation}

\item{\code{overwrite}}{Logical. Should already existing documentation be
removed or should it be merged together with \code{doc}}

\item{\code{subset}}{A character vector giving the path to the subset of the
docs to assign \code{doc} to}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber2-add_shiny"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber2-add_shiny}{}}}
\subsection{Method \code{add_shiny()}}{
Add a shiny app to an api. See \code{\link[=api_shiny]{api_shiny()}} for detailed
information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber2$add_shiny(path, app, except = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{The path to serve the app from}

\item{\code{app}}{A shiny app object}

\item{\code{except}}{Subpaths to \code{path} that should not be forwarded to the
shiny app. Be sure it doesn't contains paths that the shiny app needs}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber2-forward"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber2-forward}{}}}
\subsection{Method \code{forward()}}{
Add a reverse proxy from a path to a given URL. See
\code{\link[=api_forward]{api_forward()}} for more details
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber2$forward(path, url, except = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{The root to forward from}

\item{\code{url}}{The url to forward to}

\item{\code{except}}{Subpaths to \code{path} that should be exempt from forwarding}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plumber2-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Plumber2-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plumber2$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
