% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validateStrataArgument}
\alias{validateStrataArgument}
\title{To validate a strata list. It makes sure that elements are unique and point
to columns in table.}
\usage{
validateStrataArgument(strata, table, call = parent.frame())
}
\arguments{
\item{strata}{A list of characters that point to columns in table.}

\item{table}{A table with columns.}

\item{call}{Passed to cli functions.}
}
\value{
The same strata input or an error if the input is incorrect.
}
\description{
To validate a strata list. It makes sure that elements are unique and point
to columns in table.
}
\examples{
strata <- list("age", "sex", c("age", "sex"))
x <- dplyr::tibble(age = 30L, sex = "Female")

validateStrataArgument(strata, x)

}
