% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_qtrap.R
\name{process_mrm_duplicates}
\alias{process_mrm_duplicates}
\title{Process All MRM Transitions for Duplicates}
\usage{
process_mrm_duplicates(
  mrm_data,
  sample_name_col = "data_filename",
  sample_id_col = "sample_id",
  polarity_col = "polarity",
  retention_time_col = "retention_time",
  mass_info_col = "Mass Info",
  component_name_col = "component_name"
)
}
\arguments{
\item{mrm_data}{A tibble containing the MRM transition data.}

\item{sample_name_col}{Name of the column containing sample name information.}

\item{sample_id_col}{Name of the column containing sample ID information.}

\item{polarity_col}{Name of the column containing polarity information.}

\item{retention_time_col}{Name of the column containing retention time information.}

\item{mass_info_col}{Name of the column containing mass information.}

\item{component_name_col}{Name of the column containing component name information.}
}
\value{
The original tibble with an added `MRM_Duplicate_Flag` column.
}
\description{
This function takes a tibble containing MRM transition data, processes each sample_id separately to detect duplicates,
and adds a column `MRM_Duplicate_Flag` indicating if a row is a duplicate based on the criteria:
same polarity, less than a 1-minute retention time difference, and the same MRM transition (Q1/Q3).
}
\examples{
\dontrun{
mrm_data <- tibble::tribble(
  ~`data_filename`, ~`sample_id`, ~polarity, ~`retention_time`, ~`Mass Info`, ~`component_name`,
  "Sample1", "ID1", "Positive", 1.95, "61.0 / 44.0", "Urea_pos",
  "Sample1", "ID1", "Positive", 8.34, "206.0 / 189.0", "Lipoamide_pos",
  "Sample2", "ID2", "Positive", 2.18, "339.1 / 110.0", "AICAR_pos",
  "Sample2", "ID2", "Positive", 1.76, "175.1 / 70.0", "Arginine_pos")
processed_data <- process_mrm_duplicates(
  mrm_data,
  "data_filename",
  "sample_id",
  "polarity",
  "retention_time",
  "Mass Info",
  "component_name"
)
print(processed_data)
}
}
\author{
Yaoxiang Li
}
