% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_feature.R
\name{define_thresholds}
\alias{define_thresholds}
\title{Define Anomaly Thresholds}
\usage{
define_thresholds(
  skewness = 2.5,
  kurtosis = 10,
  shapiro_p = 1e-10,
  cooks_distance = 1,
  lof = 15
)
}
\arguments{
\item{skewness}{The threshold for skewness. Defaults to 2.5.}

\item{kurtosis}{The threshold for kurtosis. Defaults to 10.}

\item{shapiro_p}{The threshold for Shapiro-Wilk test p-value. Defaults to 1e-10.}

\item{cooks_distance}{The threshold for Cook's Distance. Defaults to 1.}

\item{lof}{The threshold for Local Outlier Factor. Defaults to 15.}
}
\value{
A list of thresholds for anomaly detection.
}
\description{
Define Anomaly Thresholds
}
\examples{
thresholds <- define_thresholds()
thresholds <- define_thresholds(skewness = 3, kurtosis = 8)
}
