% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_qtrap.R
\name{combine_logical_tibbles}
\alias{combine_logical_tibbles}
\title{Combine Multiple Logical Tibbles with Intersection or Union}
\usage{
combine_logical_tibbles(..., method = c("intersection", "union"))
}
\arguments{
\item{...}{Multiple tibbles to be combined. Each tibble should have the same
dimensions, same column names in the same order, and the first column values
should be identical across all tibbles.}

\item{method}{A string indicating the method to combine the tibbles.
Either "intersection" or "union". Default is "intersection".}
}
\value{
A combined tibble where each cell is TRUE based on the method:
- "intersection": TRUE if all corresponding cells in the input tibbles are TRUE,
otherwise FALSE.
- "union": TRUE if at least one corresponding cell in the input tibbles is TRUE,
otherwise FALSE.
}
\description{
Combine Multiple Logical Tibbles with Intersection or Union
}
\examples{
tibble1 <- tibble::tibble(id = 1:3, A = c(TRUE, FALSE, NA), B = c(TRUE, TRUE, FALSE))
tibble2 <- tibble::tibble(id = 1:3, A = c(TRUE, TRUE, TRUE), B = c(FALSE, TRUE, TRUE))
tibble3 <- tibble::tibble(id = 1:3, A = c(TRUE, FALSE, TRUE), B = c(TRUE, TRUE, NA))
combine_logical_tibbles(tibble1, tibble2, tibble3, method = "intersection")
combine_logical_tibbles(tibble1, tibble2, tibble3, method = "union")
}
\author{
Yaoxiang Li
}
