% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getnca.R
\name{getnca}
\alias{getnca}
\title{Perform non-compartmental pharmacokinetic analysis}
\usage{
getnca(
  x,
  y,
  dose = 1,
  trapezoidal.rule = c("linear_up_log_down", "linear"),
  ss = 0,
  duration = NULL,
  nlastpoints = 3,
  slope.method = c("bestfitforce", "bestfit"),
  route = c("bolus", "oral", "infusion")
)
}
\arguments{
\item{x}{Numeric vector of observation times.}

\item{y}{Numeric vector of drug concentration measurements.}

\item{dose}{Administered dose (default = 1).}

\item{trapezoidal.rule}{Method for AUC calculation:
\itemize{
\item \code{"linear"} - Linear trapezoidal method (default)
\item \code{"linear_up_log_down"} - Linear-up/log-down method (linear for ascending concentrations, logarithmic for descending)
}}

\item{ss}{Steady-state flag:
\itemize{
\item 0 - Use extrapolated \eqn{AUC_{0 \rightarrow \infty}} for clearance (default)
\item 1 - Use observed \eqn{AUC_{0 \rightarrow \mathrm{last}}} for clearance
}}

\item{duration}{Infusion duration (required if \code{route = "infusion"}).}

\item{nlastpoints}{Number of terminal points for slope estimation (default = 3).}

\item{slope.method}{Method for estimating terminal slope (\eqn{\lambda_z}):
\itemize{
\item \code{"bestfitforce"} - Force estimation using decreasing number of terminal points if best-fit fails (default)
\item \code{"bestfit"} - Use automated best-fit selection based on adjusted R-squared
}}

\item{route}{Administration route:
\itemize{
\item \code{"bolus"} - Intravenous bolus (default)
\item \code{"oral"} - Oral administration
\item \code{"infusion"} - Intravenous infusion
}}
}
\value{
A list containing:
\itemize{
\item cl - Clearance (CL), calculated as Dose/AUC
\item vz - volume of distribution (Vz), calculated as CL / lambdaz
\item half_life - Terminal elimination half-life, computed as ln(2) / lambdaz
\item auct - Area under the concentration–time curve from time 0 to last measurable concentration
\item auc0_inf - AUC extrapolated to infinity
\item C_last - Last non-zero measurable concentration
\item lambdaz - Terminal elimination rate constant
\item aumc_0_t - Area under the first moment curve from time 0 to last measurable concentration
\item aumc_0_inf - AUMC extrapolated to infinity
\item used_points - Number of time–concentration points used to estimate lambdaz
\item adj.r.squared - Adjusted R-squared of the terminal phase regression
\item messages - Warning or diagnostic messages returned during the calculation
}
}
\description{
Calculates key pharmacokinetic parameters using non-compartmental methods for both intravenous and oral administration data.
}
\examples{
# IV bolus example
dat <- data.frame(TIME = c(0.5, 1, 2, 4, 6, 8),
                  DV = c(12, 8, 5, 3, 2, 1))
getnca(x = dat$TIME, y = dat$DV, dose = 1)

# IV infusion example
dat <- data.frame(TIME = c(0.5, 1, 2, 4, 6, 8),
                  DV = c(2, 8, 5, 3, 2, 1))
getnca(x = dat$TIME, y = dat$DV, dose = 1, route = "infusion", duration = 1)

# Oral administration example
dat <- data.frame(TIME = c(0, 1, 2, 4, 6, 8),
                  DV = c(0, 9, 12, 8, 6, 2))
getnca(x = dat$TIME, y = dat$DV, route = "oral")

}
