% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Skater.R
\name{skater_leaders}
\alias{skater_leaders}
\title{Access the skater statistics leaders for a season, game type, and category}
\usage{
skater_leaders(season = "current", game_type = "", category = "points")
}
\arguments{
\item{season}{integer in YYYYYYYY (e.g., 20242025); see \code{\link[=seasons]{seasons()}} for
reference}

\item{game_type}{integer in 1:3 (where 1 = pre-season, 2 = regular season, 3
= playoff/post-season) OR character of 'pre', 'regular', or
playoff'/'post'; see \code{\link[=seasons]{seasons()}} for reference; most functions will NOT
support pre-season}

\item{category}{string of 'a'/'assists', 'g'/goals',
'shg'/'shorthanded goals', 'ppg'/'powerplay goals', 'p'/'points',
'pim'/penalty minutes'/'penalty infraction minutes', 'toi'/'time on ice',
'pm'/'plus minus', or 'f'/'faceoffs'}
}
\value{
data.frame with one row per player
}
\description{
\code{skater_leaders()} scrapes the skater statistics leaders for a given set of
\code{season}, \code{game_type}, and \code{category}.
}
\examples{
TOI_leaders_regular_20242025 <- skater_leaders(
  season    = 20242025,
  game_type = 2,
  category  = 'TOI'
)
}
