% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnet_van_genuchten.R
\name{mnet_van_genuchten}
\alias{mnet_van_genuchten}
\title{Calculate volumetric soil water content with van Genuchten curve}
\usage{
mnet_van_genuchten(MP, WCr, WCs, a, n)
}
\arguments{
\item{MP}{a vector of matric potential at which to calculate volumetric soil water content}

\item{WCr}{residual water content for dry soil}

\item{WCs}{saturated water content for wet soil}

\item{a}{the alpha parameter for the van Genuchten equation related to the
inverse of the air entry suction}

\item{n}{the n parameter for the van Genuchten equation related to the
pore-size distribution}
}
\value{
a vector of volumetric soil water content values
}
\description{
Calculate volumetric soil water content using the van Genuchten curve
}
\examples{

mnet_van_genuchten(-100, 0.034, 0.41, 0.273, 1.39)

}
