% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnet_download_mts.R
\name{mnet_download_mts}
\alias{mnet_download_mts}
\title{Download Mesonet Time Series files}
\usage{
mnet_download_mts(
  stid,
  start_date = NULL,
  end_date = NULL,
  root_url = mnet_root_url(),
  site_info = NULL,
  file_cache = NULL,
  ask = !silent,
  silent = FALSE
)
}
\arguments{
\item{stid}{a character vector of four-digit station identifiers
for the Mesonet stations from which to download data}

\item{start_date}{the first date for which to download data specified in
Central Standard Time (i.e. "America/Costa_Rica") zone as a Date or POSIXt
object or a string with the format YYYY-MM-DD, where YYYY is the four-digit
year, MM is the two-digit numeric month and DD is the two-digit day of month}

\item{end_date}{the final date for which to download data specified in
Central Standard Time (i.e. "America/Costa_Rica") zone as a Date or POSIXt
object or a string with the format YYYY-MM-DD, where YYYY is the four-digit
year, MM is the two-digit numeric month and DD is the two-digit day of month}

\item{root_url}{the root url from which to download MTS files (see
\link[mesonet]{mnet_root_url})}

\item{site_info}{a data frame with site and soil information for each
Oklahoma Mesonet station as returned by \link[mesonet]{mnet_site_info}. If
NULL, \link[mesonet]{mnet_site_info} will be used to download this
information internally}

\item{file_cache}{a character string providing a path to the local Mesonet
file cache. If NULL, the function will search for the local file cache and
if not found will prompt the user to create one.}

\item{ask}{whether or not to ask about creating a local Mesonet file cache}

\item{silent}{whether to suppress output to terminal (TRUE) or allow output
to terminal (FALSE)}
}
\value{
invisibly returns a character vector of the URLs for the downloaded
 files
}
\description{
Downloads Mesonet Time Series (MTS) files from the Oklahoma Mesonet for
 a given set of station identifiers and date range
}
\examples{
\dontshow{
  mesonet_cache_dir <- mnet_test_cache(site_info = TRUE)
  previous_options <- options(.mesonet_cache = mesonet_cache_dir)
}
#'
\donttest{
mnet_download_mts("ACME",
                  start_date = "1994-01-01",
                  end_date = "1994-01-05")
}

}
