% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/General.R
\name{createM}
\alias{createM}
\title{Create an object to symbolize the manifold.}
\usage{
createM(mfdName)
}
\arguments{
\item{mfdName}{One of 'Euclidean', 'Sphere', 'SO', 'AffInv', or 'LogEu'. The name is case sensitive.}
}
\value{
A structure 1 with class being `mfdName`
}
\description{
Create an object to symbolize the manifold. Supports the Euclidean, the unit sphere, special orthogonal group, and symmetric positive definite (SPD) matrices with either the affine invariant or the log-Euclidean metric.
}
\details{
Overall, most of the arguments in the manifold functions respect recycling rules. If the input arguments are matrices with n rows corresponding to n points, then the manifold function will be applied to each of the n pairs; the returned value will be a matrix. If one input corresponds to n points and the other just one point, then the one point will be recycled. If each component corresponds to one point, the returned value will correspond to just one point.
}
