% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{housing_pts}
\alias{housing_pts}
\title{California Housing Prices (1990 Census)}
\format{
A data frame with 20,640 observations and 10 variables:
\describe{
  \item{longitude}{Longitude coordinate of the district (numeric)}
  \item{latitude}{Latitude coordinate of the district (numeric)}
  \item{housing_median_age}{Median age of houses in the district (numeric)}
  \item{total_rooms}{Total number of rooms in the district (numeric)}
  \item{total_bedrooms}{Total number of bedrooms in the district (numeric)}
  \item{population}{Population of the district (numeric)}
  \item{households}{Number of households in the district (numeric)}
  \item{median_income}{Median income in the district (numeric)}
  \item{median_house_value}{Median house value in the district (numeric, in US dollars)}
  \item{ocean_proximity}{Proximity of the district to the ocean (character string categories)}
}
}
\source{
Data taken from Kaggle:
  \url{https://www.kaggle.com/datasets/camnugent/california-housing-prices}
}
\usage{
data(housing_pts)
}
\description{
This dataset, `housing_pts`, is a data frame containing information on median house prices
for California districts, derived from the 1990 census. It includes geographic coordinates,
demographic and housing characteristics, and district-level income and housing attributes.
The dataset consists of 20,640 observations and 10 variables. Missing values may be present
in some variables.
}
\details{
The dataset name has been kept as `housing_pts` to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of your
package and assists users in identifying its specific characteristics. The suffix `pts`
indicates that the dataset contains georeferenced point data. The original content has not
been modified in any way.
}
