% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{columbus_poly}
\alias{columbus_poly}
\title{Columbus Neighborhood Data (1980)}
\format{
A data frame with 49 observations and 22 variables:
\describe{
  \item{AREA}{Area of the neighborhood (numeric)}
  \item{PERIMETER}{Perimeter of the neighborhood (numeric)}
  \item{COLUMBUS.}{Identifier variable (integer)}
  \item{COLUMBUS.I}{Identifier variable (integer)}
  \item{POLYID}{Polygon ID (integer)}
  \item{NEIG}{Neighborhood ID (integer)}
  \item{HOVAL}{Housing value (numeric)}
  \item{INC}{Household income (numeric)}
  \item{CRIME}{Crime rate (numeric)}
  \item{OPEN}{Open space (numeric)}
  \item{PLUMB}{Plumbing quality (numeric)}
  \item{DISCBD}{Distance to central business district (numeric)}
  \item{X}{X coordinate of centroid (numeric)}
  \item{Y}{Y coordinate of centroid (numeric)}
  \item{AREA}{Area variable (numeric, duplicated)}
  \item{NSA}{Neighborhood spatial attribute A (numeric)}
  \item{NSB}{Neighborhood spatial attribute B (numeric)}
  \item{EW}{East/West indicator (numeric)}
  \item{CP}{Central place indicator (numeric)}
  \item{THOUS}{Thousands of dollars (numeric)}
  \item{NEIGNO}{Neighborhood number (numeric)}
  \item{PERIM}{Perimeter variable (numeric, duplicated)}
}
}
\source{
Data taken from the \pkg{spData} package version 2.3.4
}
\usage{
data(columbus_poly)
}
\description{
This dataset, \code{columbus_poly}, is a data frame containing socioeconomic and housing
characteristics for 49 neighborhoods in Columbus, Ohio, based on 1980 data.
The dataset is widely used in spatial econometrics and geographic analysis.
}
\details{
In addition to the attributes, the original dataset also included a polygon list
of neighborhood boundaries, a centroid matrix, and a neighbor list object, although
these are not part of \code{columbus_poly}. The matrix \code{bbs} is deprecated but
retained in other packages for compatibility.

The dataset name has been kept as \code{columbus_poly} to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
\code{lightsf} package and assists users in identifying its specific characteristics.
The suffix \code{poly} indicates that the dataset can be linked to polygon boundaries.
The original content has not been modified in any way.
}
