% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mock_exercise.R
\name{mock_exercise}
\alias{mock_exercise}
\alias{mock_chunk}
\title{Mock a learnr interactive exercise}
\usage{
mock_exercise(
  user_code = "1 + 1",
  label = "ex",
  chunks = list(),
  engine = "r",
  global_setup = NULL,
  setup_label = NULL,
  solution_code = NULL,
  code_check = NULL,
  error_check = NULL,
  check = NULL,
  tests = NULL,
  exercise.checker = NULL,
  exercise.error.check.code = NULL,
  exercise.df_print = "default",
  exercise.warn_invisible = TRUE,
  exercise.timelimit = 10,
  fig.height = 4,
  fig.width = 6.5,
  fig.retina = 2,
  version = current_exercise_version,
  ...
)

mock_chunk(label, code, exercise = FALSE, engine = "r", ...)
}
\arguments{
\item{user_code, solution_code, global_setup}{The user, solution, and global setup code, as strings.}

\item{label}{The label of the exercise.}

\item{chunks}{A list of chunks to use for the exercise. Use \code{mock_chunk()}
to create chunks.}

\item{engine}{The knitr language engine used by the exercise, equivalent to
the engine used for the chunk with \code{exercise = TRUE} in a tutorial.}

\item{setup_label}{The label of the chunk that contains the setup code. The
chunk itself should be among the list of chunks provided to the \code{chunks}
argument and the label of the setup chunk needs to match the label provided
to \code{setup_label}.}

\item{check, code_check, error_check}{The checking code, as a string, that
would typically be provided in the \code{-check}, \code{-code-check} and
\code{-error-check} chunks in a learnr tutorial.}

\item{exercise.checker}{The exercise checker function, as a string. By
default, a debug exercise checker is set but will only be used if any of
\code{check}, \code{code_check} or \code{error_check} are provided.}

\item{exercise.error.check.code}{The default code used for \code{error_check} and
applied only when \code{check} or \code{code_check} are provided and the user's code
throws an error.}

\item{exercise.df_print, exercise.warn_invisible, exercise.timelimit, fig.height, fig.width, fig.retina}{Common exercise chunk options.}

\item{version}{The exercise version to emulate, by default \code{mock_exercise()}
will return an exercise that matches the current exercise version.}

\item{...}{Additional chunk options as if there were included in the
exercise chunk.}

\item{code}{In \code{mock_chunk()}, the code in the mocked chunk.}

\item{exercise}{In \code{mock_chunk()}, is this chunk the exercise chunk? If so,
\code{mock_exercise()} will not create the exercise chunk for you.}
}
\value{
An exercise object.
}
\description{
Creates an interactive exercise object that can be used in tests without
having to create a learnr tutorial.
}
\section{Functions}{
\itemize{
\item \code{mock_exercise()}: Create a learnr exercise object

\item \code{mock_chunk()}: Create a mock exercise-supporting chunk

}}
\examples{
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true")) withAutoprint(\{ # examplesIf}
mock_exercise(
  user_code = "1 + 1",
  solution_code = "2 + 2",
  label = "two-plus-two"
)

# Global Setup
mock_exercise(
  user_code = 'storms \%>\% filter(name = "Roxanne")',
  solution_code = 'storms \%>\% filter(name == "Roxanne")',
  global_setup = 'library(learnr)\nlibrary(dplyr)',
  label = "filter-storms"
)

# Chained setup chunks
mock_exercise(
  user_code = "roxanne",
  solution_code = "roxanne \%>\%
  group_by(year, month, day) \%>\%
  summarize(wind = mean(wind))",
  chunks = list(
    mock_chunk(
      label = "prep-roxanne",
      code = 'roxanne <- storms \%>\% filter(name == "Roxanne")'
    )
  ),
  setup_label = "prep-roxanne",
  global_setup = "library(learnr)\nlibrary(dplyr)"
)
\dontshow{\}) # examplesIf}
}
\keyword{internal}
