% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params_check_types.R
\name{check_logical}
\alias{check_logical}
\title{Checks a set of variables can be coerced to a logical and coerces them}
\usage{
check_logical(
  ...,
  .message = "`{param}` is not a logical: ({err}).",
  .env = rlang::caller_env()
)
}
\arguments{
\item{...}{a list of symbols}

\item{.message}{a glue specification containing \code{{param}} as the name of the
parameter and \code{{err}} the cause of the error}

\item{.env}{the environment to check (defaults to calling environment)}
}
\value{
nothing. called for side effects. throws error if not all variables can be coerced.
}
\description{
Checks a set of variables can be coerced to a logical and coerces them
}
\examples{
a = c("T","F")
b = c(1,0,1,0)
f = TRUE
g = NA
check_logical(a,b,f,g)

c = c("dfsfs")
try(check_logical(c,d, mean))
}
\concept{parameter_checks}
