% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesize.R
\name{hypothesize}
\alias{hypothesize}
\alias{hypothesise}
\title{Declare a null hypothesis}
\usage{
hypothesize(x, null, p = NULL, mu = NULL, med = NULL, sigma = NULL)

hypothesise(x, null, p = NULL, mu = NULL, med = NULL, sigma = NULL)
}
\arguments{
\item{x}{A data frame that can be coerced into a \link[tibble:tibble]{tibble}.}

\item{null}{The null hypothesis. Options include \code{"independence"},
\code{"point"}, and \code{"paired independence"}.
\itemize{
\item \code{independence}: Should be used with both a \code{response} and \code{explanatory}
variable. Indicates that the values of the specified \code{response} variable
are independent of the associated values in \code{explanatory}.
\item \code{point}: Should be used with only a \code{response} variable. Indicates
that a point estimate based on the values in \code{response} is associated
with a parameter. Sometimes requires supplying one of \code{p}, \code{mu}, \code{med}, or
\code{sigma}.
\item \verb{paired independence}: Should be used with only a \code{response} variable
giving the pre-computed difference between paired observations. Indicates
that the order of subtraction between paired values does not affect the
resulting distribution.
}}

\item{p}{The true proportion of successes (a number between 0 and 1). To be used with point null hypotheses when the specified response
variable is categorical.}

\item{mu}{The true mean (any numerical value). To be used with point null
hypotheses when the specified response variable is continuous.}

\item{med}{The true median (any numerical value). To be used with point null
hypotheses when the specified response variable is continuous.}

\item{sigma}{The true standard deviation (any numerical value). To be used with
point null hypotheses.}
}
\value{
A tibble containing the response (and explanatory, if specified)
variable data with parameter information stored as well.
}
\description{
Declare a null hypothesis about variables selected in \code{\link[=specify]{specify()}}.

Learn more in \code{vignette("infer")}.
}
\examples{
# hypothesize independence of two variables
gss |>
 specify(college ~ partyid, success = "degree") |>
 hypothesize(null = "independence")

# hypothesize a mean number of hours worked per week of 40
gss |>
  specify(response = hours) |>
  hypothesize(null = "point", mu = 40)

# more in-depth explanation of how to use the infer package
\dontrun{
vignette("infer")
}

}
\seealso{
Other core functions: 
\code{\link{calculate}()},
\code{\link{generate}()},
\code{\link{specify}()}
}
\concept{core functions}
