/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5Dmodule.h" 

#include "H5private.h"   
#include "H5Dpkg.h"      
#include "H5Eprivate.h"  
#include "H5Iprivate.h"  
#include "H5VLprivate.h" 

herr_t
H5Ddebug(hid_t dset_id)
{
    H5D_t  *dset;                   
    haddr_t prev_tag = HADDR_UNDEF; 
    herr_t ret_value = SUCCEED;     

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (dset = (H5D_t *)H5VL_object_verify(dset_id, H5I_DATASET)))
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, FAIL, "not a dataset");

    
    H5AC_tag(dset->oloc.addr, &prev_tag);

    
    if (H5D_CHUNKED == dset->shared->layout.type)
        (void)H5D__chunk_dump_index(dset, Rstdout);
    else if (H5D_CONTIGUOUS == dset->shared->layout.type)
        Rfprintf(Rstdout, "    %-10s %" PRIuHADDR "\n", "Address:", dset->shared->layout.storage.u.contig.addr);

    
    H5AC_tag(prev_tag, NULL);

done:
    FUNC_LEAVE_API(ret_value)
} 
