% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcp_pelt.R
\name{hcp_pelt}
\alias{hcp_pelt}
\title{Pruned Exact Linear Time (PELT)}
\usage{
hcp_pelt()
}
\value{
\code{hcp_pelt} object.
}
\description{
Multiple change-point detection using the PELT algorithm for mean/variance
with a linear-time cost under suitable penalty choices. This function wraps
the PELT implementation in the \code{changepoint} package.
}
\details{
PELT performs optimal partitioning while pruning candidate change-point
locations to achieve near-linear computational cost.
}
\examples{
library(daltoolbox)

# Load change-point example data
data(examples_changepoints)

# Use a simple example
dataset <- examples_changepoints$simple
head(dataset)

# Configure the PELT detector
model <- hcp_pelt()

# Fit the detector (no-op for PELT)
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Show detected change points
print(detection[(detection$event),])

}
\references{
\itemize{
\item Killick R, Fearnhead P, Eckley IA (2012). Optimal detection of changepoints
with a linear computational cost. JASA, 107(500):1590–1598.
}
}
