% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcp_gft.R
\name{hcp_gft}
\alias{hcp_gft}
\title{Generalized Fluctuation Test (GFT)}
\usage{
hcp_gft()
}
\value{
\code{hcp_gft} object
}
\description{
Structural change detection using generalized fluctuation tests via
\code{strucchange::breakpoints()} \url{doi:10.18637/jss.v007.i02}.
}
\examples{
library(daltoolbox)

# Load change-point example data
data(examples_changepoints)

# Use a simple example
dataset <- examples_changepoints$simple
head(dataset)

# Configure the GFT detector
model <- hcp_gft()

# Fit the detector (no-op for GFT)
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Show detected change points
print(detection[(detection$event),])

}
\references{
\itemize{
\item Zeileis A, Leisch F, Kleiber C, Hornik K (2002). strucchange: An R package for testing
for structural change in linear regression models. Journal of Statistical Software, 7(2). doi:10.18637/jss.v007.i02
\item Zeileis A, Kleiber C, Krämer W, Hornik K (2003). Testing and dating of structural
changes in practice. Computational Statistics & Data Analysis, 44(1):109–123.
}
}
