% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/har_eval_soft.R
\name{har_eval_soft}
\alias{har_eval_soft}
\title{Evaluation of event detection (SoftED)}
\usage{
har_eval_soft(sw_size = 15)
}
\arguments{
\item{sw_size}{Integer. Tolerance window size for soft matching.}
}
\value{
\code{har_eval_soft} object
}
\description{
Soft evaluation of event detection using SoftED \url{doi:10.48550/arXiv.2304.00439}.
}
\examples{
library(daltoolbox)

# Load anomaly example data
data(examples_anomalies)

# Use the simple series
dataset <- examples_anomalies$simple
head(dataset)

# Configure a change-point detector (GARCH)
model <- hcp_garch()

# Fit the detector
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Show detected events
print(detection[(detection$event),])

# Evaluate detections (SoftED)
evaluation <- evaluate(har_eval_soft(), detection$event, dataset$event)
print(evaluation$confMatrix)

# Plot the results
grf <- har_plot(model, dataset$serie, detection, dataset$event)
plot(grf)

}
\references{
\itemize{
\item Salles, R., Lima, J., Reis, M., Coutinho, R., Pacitti, E., Masseglia, F., Akbarinia, R.,
Chen, C., Garibaldi, J., Porto, F., Ogasawara, E. SoftED: Metrics for soft evaluation of
time series event detection. Computers and Industrial Engineering, 2024.
doi:10.1016/j.cie.2024.110728
}
}
