% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leading_zeros.R
\name{leading_zeros}
\alias{leading_zeros}
\title{Add leading zeros}
\usage{
leading_zeros(x, left_digits = NULL, digits = 0, prefix = "", suffix = "", ...)
}
\arguments{
\item{x}{a numeric vector}

\item{left_digits}{number of digits before decimal point, automatically
computed if not provided}

\item{digits}{number of digits after decimal point}

\item{prefix, suffix}{Symbols to display before and after value}

\item{...}{additional parameters passed to \code{\link[base:formatc]{base::formatC()}},
as \code{big.mark} or \code{decimal.mark}}
}
\value{
A character vector of the same length as \code{x}.
}
\description{
Add leading zeros
}
\examples{
v <- c(2, 103.24, 1042.147, 12.4566, NA)
leading_zeros(v)
leading_zeros(v, digits = 1)
leading_zeros(v, left_digits = 6, big.mark = " ")
leading_zeros(c(0, 6, 12, 18), prefix = "M")
}
\seealso{
\code{\link[base:formatc]{base::formatC()}}, \code{\link[base:sprintf]{base::sprintf()}}
}
\keyword{utilities}
