% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lca_cor.R
\name{lca_cor}
\alias{lca_cor}
\title{Calculate item level and aggregate learning}
\usage{
lca_cor(
  transmatrix = NULL,
  nodk_priors = c(0.3, 0.1, 0.1, 0.25),
  dk_priors = c(0.3, 0.1, 0.2, 0.05, 0.1, 0.1, 0.05, 0.25)
)
}
\arguments{
\item{transmatrix}{transition matrix returned from \code{\link{multi_transmat}}}

\item{nodk_priors}{Optional. Vector of length 4. Priors for the parameters for model that fits data without Don't Knows}

\item{dk_priors}{Optional. Vector of length 8. Priors for the parameters for model that fits data with Don't Knows}
}
\value{
list with two items: parameter estimates and estimates of learning
}
\description{
guesstimate
}
\examples{
# Without DK
pre_test <- data.frame(item1 = c(1, 0, 0, 1, 0), item2 = c(1, NA, 0, 1, 0)) 
pst_test <- pre_test + cbind(c(0, 1, 1, 0, 0), c(0, 1, 0, 0, 1))
transmatrix <- multi_transmat(pre_test, pst_test)
res <- lca_cor(transmatrix)
}
