% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggsem_silent.R
\name{ggsem_silent}
\alias{ggsem_silent}
\title{Run ggsem silently (without launching the app) and get the visualization outputs}
\usage{
ggsem_silent(metadata)
}
\arguments{
\item{metadata}{A list containing ggsem workflow metadata, typically loaded from
an RDS file saved by the ggsem Shiny app using the "Export Workflow" functionality.
The metadata should contain SEM groups, network groups, visual elements, and
group labels.}
}
\value{
A list of four data frames:
\itemize{
  \item \code{points} - Data frame containing point coordinates and properties
  \item \code{lines} - Data frame containing line coordinates and properties
  \item \code{annotations} - Data frame containing text annotations
  \item \code{loops} - Data frame containing loop coordinates and properties
}
}
\description{
This function processes a saved ggsem workflow metadata file and extracts all
visualization data (points, lines, annotations, loops) that would be displayed
in the Shiny app. It reproduces both SEM and network visualizations from the
saved session state.
}
\examples{
\dontrun{
# Load a saved ggsem workflow
workflow_metadata <- readRDS("ggsem_workflow_20240101_120000.rds")

# Extract visualization data
viz_data <- ggsem_silent(workflow_metadata)

# Access the different components
points <- viz_data$points
lines <- viz_data$lines
annotations <- viz_data$annotations
loops <- viz_data$loops
}
}
