% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete-uchicago.R
\name{pal_uchicago}
\alias{pal_uchicago}
\title{The University of Chicago color palettes}
\usage{
pal_uchicago(palette = c("default", "light", "dark"), alpha = 1)
}
\arguments{
\item{palette}{Palette type.
There are three available options:
\itemize{
\item \code{"default"} (9-color palette);
\item \code{"light"} (9-color light palette);
\item \code{"dark"} (9-color dark palette).
}}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices:rgb]{grDevices::rgb()}} for details.}
}
\description{
Color palettes based on the colors used by the University of Chicago.
}
\examples{
library("scales")
show_col(pal_uchicago("default")(9))
show_col(pal_uchicago("light")(9))
show_col(pal_uchicago("dark")(9))
}
\references{
\url{https://news.uchicago.edu/sites/default/files/UCM_UniversityIdentityGuidelines_2-2020.pdf}
}
\author{
Nan Xiao | \email{me@nanx.me} | \url{https://nanx.me}
}
