% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOCodelistCatalogue.R
\docType{class}
\name{ISOCodelistCatalogue}
\alias{ISOCodelistCatalogue}
\title{ISOCodelistCatalogue}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling an ISOCodelistCatalogue
}
\description{
ISOCodelistCatalogue

ISOCodelistCatalogue
}
\references{
- ISO 19139 \url{https://schemas.isotc211.org/19139/-/cat/1.2.0/cat/#element_CT_CodelistCatalogue}
  
  - ISO 19115-3 \url{https://schemas.isotc211.org/19115/-3/cat/1.0/cat/#element_CT_CodelistCatalogue}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{citation}
\keyword{series}
\section{Super classes}{
\code{\link[geometa:geometaLogger]{geometa::geometaLogger}} -> \code{\link[geometa:ISOAbstractObject]{geometa::ISOAbstractObject}} -> \code{\link[geometa:ISOAbstractCatalogue]{geometa::ISOAbstractCatalogue}} -> \code{ISOCodelistCatalogue}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{codelistItem}}{codelist items}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ISOCodelistCatalogue-new}{\code{ISOCodelistCatalogue$new()}}
\item \href{#method-ISOCodelistCatalogue-getCodelists}{\code{ISOCodelistCatalogue$getCodelists()}}
\item \href{#method-ISOCodelistCatalogue-getCodelist}{\code{ISOCodelistCatalogue$getCodelist()}}
\item \href{#method-ISOCodelistCatalogue-clone}{\code{ISOCodelistCatalogue$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="ERROR"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-ERROR'><code>geometa::geometaLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="INFO"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-INFO'><code>geometa::geometaLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="WARN"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-WARN'><code>geometa::geometaLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addFieldAttrs"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addFieldAttrs'><code>geometa::ISOAbstractObject$addFieldAttrs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addListElement'><code>geometa::ISOAbstractObject$addListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="checkMetadataStandardCompliance"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-checkMetadataStandardCompliance'><code>geometa::ISOAbstractObject$checkMetadataStandardCompliance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="contains"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-contains'><code>geometa::ISOAbstractObject$contains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="createLocalisedProperty"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-createLocalisedProperty'><code>geometa::ISOAbstractObject$createLocalisedProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="decode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-decode'><code>geometa::ISOAbstractObject$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="delListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-delListElement'><code>geometa::ISOAbstractObject$delListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="encode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-encode'><code>geometa::ISOAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClass"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClass'><code>geometa::ISOAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClassName"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClassName'><code>geometa::ISOAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getNamespaceDefinition"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getNamespaceDefinition'><code>geometa::ISOAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isDocument"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isDocument'><code>geometa::ISOAbstractObject$isDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isFieldInheritedFrom"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isFieldInheritedFrom'><code>geometa::ISOAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="print"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-print'><code>geometa::ISOAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="save"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-save'><code>geometa::ISOAbstractObject$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setAttr"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setAttr'><code>geometa::ISOAbstractObject$setAttr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeList"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeList'><code>geometa::ISOAbstractObject$setCodeList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeListValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeListValue'><code>geometa::ISOAbstractObject$setCodeListValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeSpace"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeSpace'><code>geometa::ISOAbstractObject$setCodeSpace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setHref"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setHref'><code>geometa::ISOAbstractObject$setHref()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setId"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setId'><code>geometa::ISOAbstractObject$setId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setIsNull"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setIsNull'><code>geometa::ISOAbstractObject$setIsNull()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setValue'><code>geometa::ISOAbstractObject$setValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="stopIfMetadataStandardIsNot"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-stopIfMetadataStandardIsNot'><code>geometa::ISOAbstractObject$stopIfMetadataStandardIsNot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="validate"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-validate'><code>geometa::ISOAbstractObject$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="wrapBaseElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-wrapBaseElement'><code>geometa::ISOAbstractObject$wrapBaseElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="addFieldOfApplication"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-addFieldOfApplication'><code>geometa::ISOAbstractCatalogue$addFieldOfApplication()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="addLocale"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-addLocale'><code>geometa::ISOAbstractCatalogue$addLocale()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="addScope"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-addScope'><code>geometa::ISOAbstractCatalogue$addScope()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="addSubCatalogue"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-addSubCatalogue'><code>geometa::ISOAbstractCatalogue$addSubCatalogue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="delFieldOfApplication"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-delFieldOfApplication'><code>geometa::ISOAbstractCatalogue$delFieldOfApplication()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="delLocale"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-delLocale'><code>geometa::ISOAbstractCatalogue$delLocale()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="delScope"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-delScope'><code>geometa::ISOAbstractCatalogue$delScope()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="delSubCatalogue"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-delSubCatalogue'><code>geometa::ISOAbstractCatalogue$delSubCatalogue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="setCharacterSet"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-setCharacterSet'><code>geometa::ISOAbstractCatalogue$setCharacterSet()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="setLanguage"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-setLanguage'><code>geometa::ISOAbstractCatalogue$setLanguage()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="setName"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-setName'><code>geometa::ISOAbstractCatalogue$setName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="setVersionDate"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-setVersionDate'><code>geometa::ISOAbstractCatalogue$setVersionDate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="setVersionNumber"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-setVersionNumber'><code>geometa::ISOAbstractCatalogue$setVersionNumber()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOCodelistCatalogue-new"></a>}}
\if{latex}{\out{\hypertarget{method-ISOCodelistCatalogue-new}{}}}
\subsection{Method \code{new()}}{
Initializes object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOCodelistCatalogue$new(xml = NULL, refFile = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link[XML]{XMLInternalNode-class}}

\item{\code{refFile}}{ref file}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOCodelistCatalogue-getCodelists"></a>}}
\if{latex}{\out{\hypertarget{method-ISOCodelistCatalogue-getCodelists}{}}}
\subsection{Method \code{getCodelists()}}{
Decodes and builds an \code{ISOCodelistCatalogue} from XML. This is done
specifically for this class, without using the generic \code{ISOAbstractObject}
decoder, to make it fully decodable on package load.


Get codelists. The method ensure an harmonized output made of objects of
class \link{ISOCodelist}. In the catalogue is built of objects of class \link{ISOCodeListDictionary}, these
will be mapped as \link{ISOCodelist}, to facilitate the consumption of codelists by \pkg{geometa}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOCodelistCatalogue$getCodelists()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link[XML]{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOCodelistCatalogue-getCodelist"></a>}}
\if{latex}{\out{\hypertarget{method-ISOCodelistCatalogue-getCodelist}{}}}
\subsection{Method \code{getCodelist()}}{
Get codelist by id.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOCodelistCatalogue$getCodelist(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{id}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
object of class \link{ISOCodelist}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOCodelistCatalogue-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ISOCodelistCatalogue-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOCodelistCatalogue$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
