% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdi.r
\name{csI}
\alias{csI}
\title{Calculates the second moment of area (=area moment of inertia, Ix and Iy) and polar moment of inertia (Iz or J) for a cross-section given as an image.}
\usage{
csI(
  image_file,
  threshold = 0.5,
  channel = 4,
  method = "greater",
  scale = 1,
  return = "total"
)
}
\arguments{
\item{image_file}{Image to be read. Images can be jpeg or png files, or a previously read image saved as an object in R.}

\item{threshold}{Reference value for color criterium after which pixels that are part of the silhouette should be differentiated from the background.}

\item{channel}{color channel to which to apply the threshold criterium. Default is 4 (alpha channel of rgba image). Channel setting needs to be adjusted depending on the color mode of the image used (e.g. there are two channels to choose from in a greyscale image, and 3 in an rgb image).}

\item{method}{Method for determining which pixels to count. Default "greater" counts pixels with value greater than threshold (e.g. higher opacity, in the case of an alpha channel). "less" counts pixels with a value less than the threshold. "not" counts all pixels not precisely matching threshold. Any other character string results in only pixels exactly matching the value given as threshold being counted.}

\item{scale}{Optional scale of the image (number of pixels per linear unit).}

\item{return}{What to return, defaults to returning both x and y second moments of area and polar moment of inertia for the entire shape (if return=="total"), otherwise returns raw data matrix for all pixels.}
}
\value{
A numeric vector containing Ix, Iy and Iz for the shape (default), or a matrix containing area moments and coordinates for each pixel in the image, as well as area moments converted relative to the common centroid of the shape using parallel axis theorem.
}
\description{
Calculates the second moment of area (=area moment of inertia, Ix and Iy) and polar moment of inertia (Iz or J) for a cross-section given as an image.
}
\examples{
fdir <- system.file(package="gdi")
csI(file.path(fdir,"exdata","cross_section.png"))
}
