% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{predict.gctsc}
\alias{predict.gctsc}
\alias{predict}
\title{Predictive Distribution and Scoring for Gaussian Copula Time Series Models}
\usage{
\method{predict}{gctsc}(object, ..., method = "GHK",
                        y_obs = NULL, X_test = NULL)
}
\arguments{
\item{object}{A fitted model object of class \code{gctsc}.}

\item{...}{Not used. Included for S3 method consistency.}

\item{method}{Character string specifying the prediction method:
\code{"TMET"} or \code{"GHK"} (default: \code{"GHK"}).}

\item{y_obs}{Optional observed value used to compute CRPS and LOGS.}

\item{X_test}{Optional covariate information for prediction. Can be a named
numeric vector, or a 1-row matrix/data.frame with column names matching the
model covariates.}
}
\value{
\item{mean}{Predictive mean of \eqn{Y_{t+1}}.}
\item{median}{Predictive median of \eqn{Y_{t+1}}.}
\item{mode}{Predictive mode of \eqn{Y_{t+1}}.}
\item{variance}{Predictive variance of \eqn{Y_{t+1}}.}
\item{CRPS}{Continuous Ranked Probability Score (if \code{y_obs} is provided).}
\item{LOGS}{Logarithmic score (if \code{y_obs} is provided).}
\item{p_y}{Predictive pmf over \eqn{(0,\dots,y_{\max})}.}
\item{lower, upper}{ 95\eqn{\%} predictive interval bounds.}
}
\description{
Computes the one-step-ahead predictive distribution for a fitted Gaussian copula
time series model, including summary statistics (mean, median, mode, variance)
and optional scoring rules (CRPS and LOGS) if an observed value is supplied.
}
\seealso{
\code{\link{gctsc}}, \code{\link{arma.cormat}}
}
