\name{action_tagging}
\alias{g3a_predate_tagrelease}
\alias{g3a_tag_shedding}
\concept{G3 action}

\title{Gadget3 tag-release action}
\description{
  Add tag-release to a g3 model
}

\usage{
g3a_predate_tagrelease(
       fleet_stock, prey_stocks, suitabilities, catchability_f,
       output_tag_f, mortality_f = 0, run_f = ~TRUE,
       run_at = g3_action_order$predate, ...)

g3a_tag_shedding(stocks, tagshed_f, run_f = ~TRUE,
       run_at = g3_action_order$straying)
}

\arguments{
  \item{fleet_stock}{Tagging fleet, see \link{g3a_predate_fleet}}
  \item{prey_stocks}{Stocks fleet harvests, see \link{g3a_predate_fleet}}
  \item{suitabilities}{See \link{g3a_predate_fleet}}
  \item{catchability_f}{See \link{g3a_predate_fleet}}
  \item{output_tag_f}{
    \link{formula} specifying which numeric tag (see \link{g3s_tag}) stock will be released into.
    Implemented with a \link{g3_timeareadata} table, e.g.
  }
  \item{mortality_f}{
    \link{formula} generated by one of the \link{g3_suitability_*} functions, describing
    the proportion of tagged stock that will die during tagging.
  }
  \item{stocks}{Stocks that will shed tags}
  \item{tagshed_f}{\link{formula} for proportion that will shed tags at this point}
  \item{run_f}{
    \link{formula} specifying a condition for running this action, default always runs.
  }
  \item{run_at}{
    Integer order that spawning actions will be run within model, see \code{\link{g3_action_order}}.
  }
  \item{...}{Any further options for \link{g3a_predate_fleet}}
}

\value{
  \subsection{g3a_predate_tagrelease}{An action (i.e. list of formula objects) that will...\enumerate{
    \item{Harvest as-per \link{g3a_predate_fleet}}
    \item{Use \var{mortality_f} to apply tagging mortality to harvested stock}
    \item{Use \var{output_tag_f} to decide what tag should be applied to harvested stock}
    \item{Put harvested stock back into general circulation}
  }}
  \subsection{g3a_tag_shedding}{An action (i.e. list of formula objects) that will...\enumerate{
    \item{For each \var{stock}, move the proportion \var{tagshed_f} back to the "untagged" tag}
  }}
}

\seealso{
  \code{\link{g3a_predate_fleet}},
  \code{\link{g3s_tag}}
}

\examples{
\dontshow{library(magrittr)}

tags <- c('H1-00', 'H1-01')
tags <- structure(seq_along(tags), names = tags)

prey_a <- g3_stock('prey_a', seq(1, 10)) \%>\% g3s_tag(tags)
fleet_a <- g3_fleet('fleet_a')

actions <- list(
    # NB: If g3_tag() is used in the stock, initialconditions/renewal
    # will only renew into tag == 0 (i.e. untagged)
    g3a_predate_tagrelease(
        # Setup as-per g3a_predate_fleet
        fleet_a,
        list(prey_a),
        suitabilities = list(prey_a = 1),
        catchability_f = g3a_predate_catchability_numberfleet(~100),
        
        # Optional tag mortality suitability
        mortality_f = g3_suitability_straightline(
            g3_parameterized('mort_alpha'),
            g3_parameterized('mort_beta')),

        # Formula to decide which tag to output into, generate table
        # with one tag per year
        output_tag_f = g3_timeareadata('fleet_a_tags', data.frame(
            year = 2000:2001,
            tag = tags[c('H1-00', 'H1-01')],
            stringsAsFactors = FALSE), value_field = "tag"),

        # Experiment only happens in spring
        run_f = ~cur_step == 2),

    g3a_tag_shedding(
        list(prey_a),
        # i.e. 0.125 will loose their tag each step
        tagshed_f = log(8)))
}
