% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_faunabr.R
\name{get_faunabr}
\alias{get_faunabr}
\title{Download the latest version of Catálogo Taxonômico da Fauna do Brasil}
\usage{
get_faunabr(output_dir, data_version = "latest",
                 solve_discrepancies = TRUE, translate = TRUE,
                 overwrite = TRUE, verbose = TRUE)
}
\arguments{
\item{output_dir}{(character) a directory to save the data downloaded from
Fauna do Brasil}

\item{data_version}{(character) Version of the Fauna do Brasil database to
download. Use "latest" to get the most recent version, which is updated
frequently. Alternatively, specify an older version (e.g.,
data_version = "1.2").Default value is "latest".}

\item{solve_discrepancies}{Resolve inconsistencies between species and
subspecies  information. When set to TRUE (default), species
information is updated based on unique data from subspecies.
For example, if a subspecies occurs in a certain state, it implies that the
species also occurs in that state.}

\item{translate}{(logical) whether to translate the original dataset
("lifeForm", "origin", "habitat", and "taxonRank") from Portuguese to English.
Default is TRUE.}

\item{overwrite}{(logical) If TRUE, data is overwritten. Default = TRUE.}

\item{verbose}{(logical) Whether to display messages during function
execution. Set to TRUE to enable display, or FALSE to run silently.
Default = TRUE.}
}
\value{
The function downloads the latest version of the Catálogo Taxonômico da Fauna
do Brasil database from the official source. It then merges the information
into a single data.frame, containing details on species, taxonomy, occurrence,
and other relevant data.
The merged data.frame is then saved as a file in the specified output
directory. The data is saved in a format that allows easy loading using the
\code{\link{load_faunabr}} function for further analysis in R.
}
\description{
This function downloads the latest or an older version of Catálogo Taxonômico
da Fauna do Brasil database, merges the information into a single data.frame,
and saves this data.frame in the specified directory.
}
\examples{
\dontrun{
#Creating a folder in a temporary directory
#Replace 'file.path(tempdir(), "faunaabr")' by a path folder to be create in
#your computer
my_dir <- file.path(file.path(tempdir(), "faunabr"))
dir.create(my_dir)
#Download, merge and save data
get_faunabr(output_dir = my_dir)
}
}
\references{
Brazilian Zoology Group. Catálogo Taxonômico da Fauna do Brasil. Available at:
https://ipt.jbrj.gov.br/jbrj/resource?r=catalogo_taxonomico_da_fauna_do_brasil
}
