% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fauna_spat_occ.R
\name{fauna_spat_occ}
\alias{fauna_spat_occ}
\title{Get Spatial polygons (SpatVectors) of species based on its distribution
(states and countrys) according to Fauna do Brasil}
\usage{
fauna_spat_occ(data, species, state = TRUE, country = TRUE,
                      spat_state = NULL, spat_country = NULL, verbose = TRUE)
}
\arguments{
\item{data}{(data.frame) the data.frame imported with the
\code{\link{load_faunabr}} function.}

\item{species}{(character) one or more species names (only genus and
specific epithet, eg. "Panthera onca")}

\item{state}{(logical) get SpatVector of states with occurrence of the
species? Default = TRUE}

\item{country}{(logical) get SpatVector of countrys with occurrence of the
species? Default = TRUE}

\item{spat_state}{(SpatVector) a SpatVector of the Brazilian states. By
default, it uses the SpatVector provided by geobr::read_state(). It can be
another Spatvector, but the structure must be identical to
'faunabr::states', with a column called "abbrev_state" identifying the states
codes.}

\item{spat_country}{(SpatVector) a SpatVector of the world countries. By
default, it uses the SpatVector provided by rnaturalearth::ne_countries. It
can be another Spatvector, but the structure must be identical to
'faunabr::world_fauna', with a column called "country_code" identifying the
country codes.}

\item{verbose}{(logical) Whether to display species being filtered during
function execution. Set to TRUE to enable display, or FALSE to run silently.
Default = TRUE.}
}
\value{
A list with SpatVectors of states and/or countrys for each
specie.
}
\description{
Get Spatial polygons (SpatVectors) of species based on its distribution
(states and countrys) according to Fauna do Brasil
}
\examples{
library(terra)
data("fauna_data")
spp <- c("Panthera onca", "Mazama jucunda")
#Get states, countrys and intersection states-countrys of species
spp_spt <- fauna_spat_occ(data = fauna_data, species = spp, state = TRUE,
                          country = TRUE, verbose = TRUE)
#Plot states with confirmed occurrence of Panthera onca and Mazama jucunda
plot(spp_spt$`Panthera onca`$states)
plot(spp_spt$`Mazama jucunda`$states)
#Plot countries with confirmed occurrence of Panthera onca and Mazama jucunda
plot(spp_spt$`Panthera onca`$countries)
plot(spp_spt$`Mazama jucunda`$countries)

}
