% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/did_imputation.R
\name{did_imputation}
\alias{did_imputation}
\title{Borusyak, Jaravel, and Spiess (2021) Estimator}
\usage{
did_imputation(
  data,
  yname,
  gname,
  tname,
  idname,
  first_stage = NULL,
  wname = NULL,
  wtr = NULL,
  horizon = NULL,
  pretrends = NULL,
  cluster_var = NULL
)
}
\arguments{
\item{data}{A \code{data.frame}}

\item{yname}{String. Variable name for outcome. Use \code{fixest} c() syntax
for multiple lhs, e.g. \code{"c(y1, y2)"}.}

\item{gname}{String. Variable name for unit-specific date of treatment
(never-treated should be zero or \code{NA}).}

\item{tname}{String. Variable name for calendar period.}

\item{idname}{String. Variable name for unique unit id.}

\item{first_stage}{Formula for Y(0).
Formula following \code{\link[fixest:feols]{fixest::feols}}.
Fixed effects specified after "\code{|}".
If not specified, then just unit and time fixed effects will be used.}

\item{wname}{String. Variable name for estimation weights of observations.
This is used in estimating Y(0) and also augments treatment effect weights.}

\item{wtr}{Character vector of treatment weight names
(see horizon for standard static and event-study weights)}

\item{horizon}{Integer vector of event_time or \code{TRUE}. This only applies if \code{wtr} is left
as \code{NULL}. if specified, weighted averages/sums of treatment effects will be
reported for each of these horizons separately (i.e. tau0 for the treatment
period, tau1 for one period after treatment, etc.).
If \code{TRUE}, all horizons are used.
If \code{wtr} and \code{horizon} are null, then the static treatment effect is calculated.}

\item{pretrends}{Integer vector or \code{TRUE}. Which pretrends to estimate.
If \code{TRUE}, all \code{pretrends} are used.}

\item{cluster_var}{String. Variable name for clustering groups. If not
supplied, then \code{idname} is used as default.}
}
\value{
A \code{data.frame} containing treatment effect term, estimate, standard
error and confidence interval. This is in \code{tidy} format.
}
\description{
Treatment effect estimation and pre-trend testing in staggered adoption
diff-in-diff designs with an imputation approach of Borusyak, Jaravel, and
Spiess (2021)
}
\details{
The imputation-based estimator is a method of calculating treatment effects
in a difference-in-differences framework. The method estimates a model for
Y(0) using untreated/not-yet-treated observations and predicts Y(0) for the
treated observations hat(Y_it(0)). The difference between treated and
predicted untreated outcomes Y_it(1) - hat(Y_it(0)) serves as an estimate
for the treatment effect for unit i in period t. These are then averaged to
form average treatment effects for groups of (i, t).
}
\section{Examples}{


Load example dataset which has two treatment groups and homogeneous treatment effects

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Load Example Dataset
data("df_hom", package="didimputation")
}\if{html}{\out{</div>}}
\subsection{Static TWFE}{

You can run a static TWFE fixed effect model for a simple treatment indicator

\if{html}{\out{<div class="sourceCode r">}}\preformatted{did_imputation(data = df_hom, yname = "dep_var", gname = "g",
               tname = "year", idname = "unit")
#>      term estimate  std.error conf.low conf.high
#>    <char>    <num>      <num>    <num>     <num>
#> 1:  treat 2.024639 0.03243596 1.961065  2.088214
}\if{html}{\out{</div>}}
}

\subsection{Event Study}{

Or you can use relative-treatment indicators to estimate an event study estimate

\if{html}{\out{<div class="sourceCode r">}}\preformatted{did_imputation(data = df_hom, yname = "dep_var", gname = "g",
               tname = "year", idname = "unit", horizon=TRUE)
#>       term estimate  std.error conf.low conf.high
#>     <char>    <num>      <num>    <num>     <num>
#>  1:      0 2.117232 0.07368419 1.972811  2.261653
#>  2:      1 1.856536 0.07672104 1.706163  2.006909
#>  3:      2 1.986357 0.07137180 1.846468  2.126246
#>  4:      3 2.004843 0.07653409 1.854836  2.154850
#>  5:      4 1.950228 0.07543636 1.802372  2.098083
#>  6:      5 2.038302 0.07580288 1.889728  2.186875
#>  7:      6 2.031571 0.07223098 1.889999  2.173144
#>  8:      7 2.025286 0.07541719 1.877468  2.173104
#>  9:      8 1.976081 0.07493409 1.829210  2.122951
#> 10:      9 2.121434 0.07268404 1.978974  2.263895
#> 11:     10 2.087984 0.08271442 1.925864  2.250105
#> 12:     11 1.942825 0.11421421 1.718965  2.166685
#> 13:     12 1.940532 0.11200348 1.721005  2.160059
#> 14:     13 1.964569 0.11361969 1.741875  2.187264
#> 15:     14 2.023456 0.11753255 1.793092  2.253820
#> 16:     15 2.235051 0.12110086 1.997693  2.472409
#> 17:     16 2.178438 0.11552325 1.952013  2.404864
#> 18:     17 1.935576 0.11278311 1.714521  2.156631
#> 19:     18 2.134953 0.10993120 1.919488  2.350418
#> 20:     19 2.111984 0.11146282 1.893517  2.330451
#> 21:     20 1.925168 0.11214206 1.705370  2.144967
#>       term estimate  std.error conf.low conf.high
}\if{html}{\out{</div>}}
}

\subsection{Example from Cheng and Hoekstra (2013)}{

Here's an example using data from Cheng and Hoekstra (2013)

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Castle Data
castle = haven::read_dta("https://github.com/scunning1975/mixtape/raw/master/castle.dta")

did_imputation(data = castle, yname = "c(l_homicide, l_assault)", gname = "effyear",
              first_stage = ~ 0 | sid + year,
              tname = "year", idname = "sid")
#> Key: <lhs>
#>           lhs   term   estimate  std.error    conf.low conf.high
#>        <char> <char>      <num>      <num>       <num>     <num>
#> 1:  l_assault  treat 0.04955260 0.05132258 -0.05103966 0.1501449
#> 2: l_homicide  treat 0.07980155 0.06088398 -0.03953105 0.1991341
}\if{html}{\out{</div>}}
}
}

