% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_labels.R
\name{var_labels}
\alias{var_labels}
\alias{var_labels<-}
\title{Get or set all variable labels on a dataset}
\usage{
var_labels(
  x,
  unlist = FALSE,
  null_action = c("keep", "fill", "skip", "na", "empty")
)

var_labels(x) <- value
}
\arguments{
\item{x}{A \code{data.frame} or \code{\link{dataset_df}} object.}

\item{unlist}{Logical; if \code{TRUE}, return a named character vector instead
of a list. Defaults to \code{FALSE}.}

\item{null_action}{How to handle columns without labels. One of:
\itemize{
\item \code{"keep"} (default): keep \code{NULL} values for unlabeled columns.
\item \code{"fill"}: use the column name as a fallback label.
\item \code{"skip"}: exclude unlabeled columns from the result.
\item \code{"na"}: use \code{NA_character_} for unlabeled columns.
\item \code{"empty"}: use an empty string \code{""} for unlabeled columns.
}}

\item{value}{\itemize{
\item For setting: a named list or named character vector of labels.
Names must match column names in \code{x}.
Unnamed elements are ignored.
\itemize{
\item For getting: ignored.
}
}}
}
\value{
\itemize{
\item Getter: a named list (or vector if \code{unlist = TRUE}) of variable labels.
\item Setter: the modified \code{x} with updated labels, returned invisibly.
}
}
\description{
Retrieve or assign labels for all variables (columns) in a dataset.
}
\details{
This is the dataset-level equivalent of \code{\link[=var_label]{var_label()}}.
It works with any \code{data.frame}-like object, including \code{\link[=dataset_df]{dataset_df()}}, and
returns/sets the \code{"label"} attribute of each column.

Labels are useful for storing human-readable descriptions of variables that
may have short or cryptic column names.

For internal purposes, this function uses the \code{"var_labels"} dataset
attribute and delegates to \code{\link[=var_label]{var_label()}} and
\code{\link[=var_label<-]{var_label<-()}} on individual columns.
}
\examples{
df <- dataset_df(
  id = defined(1:3, label = "Observation ID"),
  temp = defined(c(22.5, 23.0, 21.8), label = "Temperature (°C)"),
  site = defined(c("A", "B", "A"))
)

# Get all variable labels
var_labels(df)

# Set multiple labels at once
var_labels(df) <- list(site = "Site code")

# Return as a named vector with empty string for unlabeled vars
var_labels(df, unlist = TRUE, null_action = "empty")

}
\seealso{
\code{\link[=var_label]{var_label()}}

Other defined metadata methods and functions: 
\code{\link{var_label}()},
\code{\link{var_namespace}()},
\code{\link{var_unit}()}
}
\concept{defined metadata methods and functions}
